package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoTune(
    autoTuneType: Optional[zio.aws.opensearch.model.AutoTuneType] =
      Optional.Absent,
    autoTuneDetails: Optional[zio.aws.opensearch.model.AutoTuneDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AutoTune = {
    import AutoTune.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AutoTune
      .builder()
      .optionallyWith(autoTuneType.map(value => value.unwrap))(_.autoTuneType)
      .optionallyWith(autoTuneDetails.map(value => value.buildAwsValue()))(
        _.autoTuneDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AutoTune.ReadOnly =
    zio.aws.opensearch.model.AutoTune.wrap(buildAwsValue())
}
object AutoTune {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AutoTune
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AutoTune =
      zio.aws.opensearch.model.AutoTune(
        autoTuneType.map(value => value),
        autoTuneDetails.map(value => value.asEditable)
      )
    def autoTuneType: Optional[zio.aws.opensearch.model.AutoTuneType]
    def autoTuneDetails
        : Optional[zio.aws.opensearch.model.AutoTuneDetails.ReadOnly]
    def getAutoTuneType
        : ZIO[Any, AwsError, zio.aws.opensearch.model.AutoTuneType] =
      AwsError.unwrapOptionField("autoTuneType", autoTuneType)
    def getAutoTuneDetails: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AutoTuneDetails.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneDetails", autoTuneDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTune
  ) extends zio.aws.opensearch.model.AutoTune.ReadOnly {
    override val autoTuneType: Optional[zio.aws.opensearch.model.AutoTuneType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTuneType())
        .map(value => zio.aws.opensearch.model.AutoTuneType.wrap(value))
    override val autoTuneDetails
        : Optional[zio.aws.opensearch.model.AutoTuneDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTuneDetails())
        .map(value => zio.aws.opensearch.model.AutoTuneDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTune
  ): zio.aws.opensearch.model.AutoTune.ReadOnly = new Wrapper(impl)
}
