package zio.aws.nimble
import zio.aws.nimble.model.primitives.{
  StreamingImageId,
  SecurityGroupId,
  EC2SubnetId,
  LaunchProfileProtocolVersion,
  ActiveDirectoryDnsIpAddress
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.nimble.model.primitives.StreamingImageDescription.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ActiveDirectoryComputerAttributeName extends Subtype[String]
    type ActiveDirectoryComputerAttributeName =
      zio.aws.nimble.model.primitives.ActiveDirectoryComputerAttributeName.Type
    object ActiveDirectoryComputerAttributeValue extends Subtype[String]
    type ActiveDirectoryComputerAttributeValue =
      zio.aws.nimble.model.primitives.ActiveDirectoryComputerAttributeValue.Type
    object ActiveDirectoryDnsIpAddress extends Subtype[String]
    type ActiveDirectoryDnsIpAddress =
      zio.aws.nimble.model.primitives.ActiveDirectoryDnsIpAddress.Type
    object ActiveDirectoryOrganizationalUnitDistinguishedName
        extends Subtype[String]
    type ActiveDirectoryOrganizationalUnitDistinguishedName =
      zio.aws.nimble.model.primitives.ActiveDirectoryOrganizationalUnitDistinguishedName.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.nimble.model.primitives.ClientToken.Type
    object DirectoryId extends Subtype[String]
    type DirectoryId = zio.aws.nimble.model.primitives.DirectoryId.Type
    object EC2ImageId extends Subtype[String]
    type EC2ImageId = zio.aws.nimble.model.primitives.EC2ImageId.Type
    object EC2SubnetId extends Subtype[String]
    type EC2SubnetId = zio.aws.nimble.model.primitives.EC2SubnetId.Type
    object EulaAcceptanceId extends Subtype[String]
    type EulaAcceptanceId =
      zio.aws.nimble.model.primitives.EulaAcceptanceId.Type
    object EulaId extends Subtype[String]
    type EulaId = zio.aws.nimble.model.primitives.EulaId.Type
    object EulaName extends Subtype[String]
    type EulaName = zio.aws.nimble.model.primitives.EulaName.Type
    object LaunchProfileDescription extends Subtype[String]
    type LaunchProfileDescription =
      zio.aws.nimble.model.primitives.LaunchProfileDescription.Type
    object LaunchProfileId extends Subtype[String]
    type LaunchProfileId = zio.aws.nimble.model.primitives.LaunchProfileId.Type
    object LaunchProfileName extends Subtype[String]
    type LaunchProfileName =
      zio.aws.nimble.model.primitives.LaunchProfileName.Type
    object LaunchProfileProtocolVersion extends Subtype[String]
    type LaunchProfileProtocolVersion =
      zio.aws.nimble.model.primitives.LaunchProfileProtocolVersion.Type
    object LaunchProfileValidationStatusMessage extends Subtype[String]
    type LaunchProfileValidationStatusMessage =
      zio.aws.nimble.model.primitives.LaunchProfileValidationStatusMessage.Type
    object LaunchPurpose extends Subtype[String]
    type LaunchPurpose = zio.aws.nimble.model.primitives.LaunchPurpose.Type
    object LinuxMountPoint extends Subtype[String]
    type LinuxMountPoint = zio.aws.nimble.model.primitives.LinuxMountPoint.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.nimble.model.primitives.MaxResults.Type
    object Region extends Subtype[String]
    type Region = zio.aws.nimble.model.primitives.Region.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.nimble.model.primitives.RoleArn.Type
    object ScriptParameterKey extends Subtype[String]
    type ScriptParameterKey =
      zio.aws.nimble.model.primitives.ScriptParameterKey.Type
    object ScriptParameterValue extends Subtype[String]
    type ScriptParameterValue =
      zio.aws.nimble.model.primitives.ScriptParameterValue.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId = zio.aws.nimble.model.primitives.SecurityGroupId.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString = zio.aws.nimble.model.primitives.SensitiveString.Type
    object StreamConfigurationMaxBackupsToRetain extends Subtype[Int]
    type StreamConfigurationMaxBackupsToRetain =
      zio.aws.nimble.model.primitives.StreamConfigurationMaxBackupsToRetain.Type
    object StreamConfigurationMaxSessionLengthInMinutes extends Subtype[Int]
    type StreamConfigurationMaxSessionLengthInMinutes =
      zio.aws.nimble.model.primitives.StreamConfigurationMaxSessionLengthInMinutes.Type
    object StreamConfigurationMaxStoppedSessionLengthInMinutes
        extends Subtype[Int]
    type StreamConfigurationMaxStoppedSessionLengthInMinutes =
      zio.aws.nimble.model.primitives.StreamConfigurationMaxStoppedSessionLengthInMinutes.Type
    object StreamingImageDescription extends Subtype[String]
    type StreamingImageDescription =
      zio.aws.nimble.model.primitives.StreamingImageDescription.Type
    object StreamingImageEncryptionConfigurationKeyArn extends Subtype[String]
    type StreamingImageEncryptionConfigurationKeyArn =
      zio.aws.nimble.model.primitives.StreamingImageEncryptionConfigurationKeyArn.Type
    object StreamingImageId extends Subtype[String]
    type StreamingImageId =
      zio.aws.nimble.model.primitives.StreamingImageId.Type
    object StreamingImageName extends Subtype[String]
    type StreamingImageName =
      zio.aws.nimble.model.primitives.StreamingImageName.Type
    object StreamingImageOwner extends Subtype[String]
    type StreamingImageOwner =
      zio.aws.nimble.model.primitives.StreamingImageOwner.Type
    object StreamingImagePlatform extends Subtype[String]
    type StreamingImagePlatform =
      zio.aws.nimble.model.primitives.StreamingImagePlatform.Type
    object StreamingSessionId extends Subtype[String]
    type StreamingSessionId =
      zio.aws.nimble.model.primitives.StreamingSessionId.Type
    object StreamingSessionStorageRootPathLinux extends Subtype[String]
    type StreamingSessionStorageRootPathLinux =
      zio.aws.nimble.model.primitives.StreamingSessionStorageRootPathLinux.Type
    object StreamingSessionStorageRootPathWindows extends Subtype[String]
    type StreamingSessionStorageRootPathWindows =
      zio.aws.nimble.model.primitives.StreamingSessionStorageRootPathWindows.Type
    object StreamingSessionStreamExpirationInSeconds extends Subtype[Int]
    type StreamingSessionStreamExpirationInSeconds =
      zio.aws.nimble.model.primitives.StreamingSessionStreamExpirationInSeconds.Type
    object StudioComponentDescription extends Subtype[String]
    type StudioComponentDescription =
      zio.aws.nimble.model.primitives.StudioComponentDescription.Type
    object StudioComponentId extends Subtype[String]
    type StudioComponentId =
      zio.aws.nimble.model.primitives.StudioComponentId.Type
    object StudioComponentInitializationScriptContent extends Subtype[String]
    type StudioComponentInitializationScriptContent =
      zio.aws.nimble.model.primitives.StudioComponentInitializationScriptContent.Type
    object StudioComponentName extends Subtype[String]
    type StudioComponentName =
      zio.aws.nimble.model.primitives.StudioComponentName.Type
    object StudioDisplayName extends Subtype[String]
    type StudioDisplayName =
      zio.aws.nimble.model.primitives.StudioDisplayName.Type
    object StudioEncryptionConfigurationKeyArn extends Subtype[String]
    type StudioEncryptionConfigurationKeyArn =
      zio.aws.nimble.model.primitives.StudioEncryptionConfigurationKeyArn.Type
    object StudioName extends Subtype[String]
    type StudioName = zio.aws.nimble.model.primitives.StudioName.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.nimble.model.primitives.Timestamp.Type
    object VolumeIops extends Subtype[Int]
    type VolumeIops = zio.aws.nimble.model.primitives.VolumeIops.Type
    object VolumeSizeInGiB extends Subtype[Int]
    type VolumeSizeInGiB = zio.aws.nimble.model.primitives.VolumeSizeInGiB.Type
    object VolumeThroughputInMiBs extends Subtype[Int]
    type VolumeThroughputInMiBs =
      zio.aws.nimble.model.primitives.VolumeThroughputInMiBs.Type
    object WindowsMountDrive extends Subtype[String]
    type WindowsMountDrive =
      zio.aws.nimble.model.primitives.WindowsMountDrive.Type
  }
  type ActiveDirectoryComputerAttributeList =
    List[zio.aws.nimble.model.ActiveDirectoryComputerAttribute]
  type ActiveDirectoryDnsIpAddressList = List[ActiveDirectoryDnsIpAddress]
  type EC2SubnetIdList = List[EC2SubnetId]
  type EulaAcceptanceList = List[zio.aws.nimble.model.EulaAcceptance]
  type EulaIdList = List[String]
  type EulaList = List[zio.aws.nimble.model.Eula]
  type LaunchProfileInitializationScriptList =
    List[zio.aws.nimble.model.LaunchProfileInitializationScript]
  type LaunchProfileList = List[zio.aws.nimble.model.LaunchProfile]
  type LaunchProfileMembershipList =
    List[zio.aws.nimble.model.LaunchProfileMembership]
  type LaunchProfileProtocolVersionList = List[LaunchProfileProtocolVersion]
  type LaunchProfileSecurityGroupIdList = List[SecurityGroupId]
  type LaunchProfileStateList = List[zio.aws.nimble.model.LaunchProfileState]
  type LaunchProfileStudioComponentIdList = List[String]
  type NewLaunchProfileMemberList =
    List[zio.aws.nimble.model.NewLaunchProfileMember]
  type NewStudioMemberList = List[zio.aws.nimble.model.NewStudioMember]
  type StreamingImageIdList = List[StreamingImageId]
  type StreamingImageList = List[zio.aws.nimble.model.StreamingImage]
  type StreamingInstanceTypeList =
    List[zio.aws.nimble.model.StreamingInstanceType]
  type StreamingSessionBackupList =
    List[zio.aws.nimble.model.StreamingSessionBackup]
  type StreamingSessionList = List[zio.aws.nimble.model.StreamingSession]
  type StreamingSessionStorageModeList =
    List[zio.aws.nimble.model.StreamingSessionStorageMode]
  type StringList = List[String]
  type StudioComponentInitializationScriptList =
    List[zio.aws.nimble.model.StudioComponentInitializationScript]
  type StudioComponentList = List[zio.aws.nimble.model.StudioComponent]
  type StudioComponentScriptParameterKeyValueList =
    List[zio.aws.nimble.model.ScriptParameterKeyValue]
  type StudioComponentSecurityGroupIdList = List[SecurityGroupId]
  type StudioComponentStateList =
    List[zio.aws.nimble.model.StudioComponentState]
  type StudioComponentSummaryList =
    List[zio.aws.nimble.model.StudioComponentSummary]
  type StudioComponentTypeList = List[zio.aws.nimble.model.StudioComponentType]
  type StudioList = List[zio.aws.nimble.model.Studio]
  type StudioMembershipList = List[zio.aws.nimble.model.StudioMembership]
  type Tags = Map[String, String]
  type ValidationResults = List[zio.aws.nimble.model.ValidationResult]
}
