package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait VolumeRetentionMode {
  def unwrap: software.amazon.awssdk.services.nimble.model.VolumeRetentionMode
}
object VolumeRetentionMode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.VolumeRetentionMode
  ): zio.aws.nimble.model.VolumeRetentionMode = value match {
    case software.amazon.awssdk.services.nimble.model.VolumeRetentionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.VolumeRetentionMode.RETAIN =>
      val r = RETAIN
      r
    case software.amazon.awssdk.services.nimble.model.VolumeRetentionMode.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.VolumeRetentionMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.VolumeRetentionMode =
      software.amazon.awssdk.services.nimble.model.VolumeRetentionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object RETAIN extends zio.aws.nimble.model.VolumeRetentionMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.VolumeRetentionMode =
      software.amazon.awssdk.services.nimble.model.VolumeRetentionMode.RETAIN
  }
  case object DELETE extends zio.aws.nimble.model.VolumeRetentionMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.VolumeRetentionMode =
      software.amazon.awssdk.services.nimble.model.VolumeRetentionMode.DELETE
  }
}
