package zio.aws.nimble.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{
  VolumeThroughputInMiBs,
  VolumeSizeInGiB,
  VolumeIops
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class VolumeConfiguration(
    iops: Optional[VolumeIops] = Optional.Absent,
    size: Optional[VolumeSizeInGiB] = Optional.Absent,
    throughput: Optional[VolumeThroughputInMiBs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.VolumeConfiguration = {
    import VolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.VolumeConfiguration
      .builder()
      .optionallyWith(iops.map(value => VolumeIops.unwrap(value): Integer))(
        _.iops
      )
      .optionallyWith(
        size.map(value => VolumeSizeInGiB.unwrap(value): Integer)
      )(_.size)
      .optionallyWith(
        throughput.map(value => VolumeThroughputInMiBs.unwrap(value): Integer)
      )(_.throughput)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.VolumeConfiguration.ReadOnly =
    zio.aws.nimble.model.VolumeConfiguration.wrap(buildAwsValue())
}
object VolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.VolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.VolumeConfiguration =
      zio.aws.nimble.model.VolumeConfiguration(
        iops.map(value => value),
        size.map(value => value),
        throughput.map(value => value)
      )
    def iops: Optional[VolumeIops]
    def size: Optional[VolumeSizeInGiB]
    def throughput: Optional[VolumeThroughputInMiBs]
    def getIops: ZIO[Any, AwsError, VolumeIops] =
      AwsError.unwrapOptionField("iops", iops)
    def getSize: ZIO[Any, AwsError, VolumeSizeInGiB] =
      AwsError.unwrapOptionField("size", size)
    def getThroughput: ZIO[Any, AwsError, VolumeThroughputInMiBs] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.VolumeConfiguration
  ) extends zio.aws.nimble.model.VolumeConfiguration.ReadOnly {
    override val iops: Optional[VolumeIops] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => zio.aws.nimble.model.primitives.VolumeIops(value))
    override val size: Optional[VolumeSizeInGiB] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => zio.aws.nimble.model.primitives.VolumeSizeInGiB(value))
    override val throughput: Optional[VolumeThroughputInMiBs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughput())
        .map(value =>
          zio.aws.nimble.model.primitives.VolumeThroughputInMiBs(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.VolumeConfiguration
  ): zio.aws.nimble.model.VolumeConfiguration.ReadOnly = new Wrapper(impl)
}
