package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StreamingImageName,
  StreamingImageDescription,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStreamingImageRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[StreamingImageDescription] = Optional.Absent,
    name: Optional[StreamingImageName] = Optional.Absent,
    streamingImageId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest = {
    import UpdateStreamingImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          StreamingImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value => StreamingImageName.unwrap(value): java.lang.String)
      )(_.name)
      .streamingImageId(streamingImageId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateStreamingImageRequest.ReadOnly =
    zio.aws.nimble.model.UpdateStreamingImageRequest.wrap(buildAwsValue())
}
object UpdateStreamingImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateStreamingImageRequest =
      zio.aws.nimble.model.UpdateStreamingImageRequest(
        clientToken.map(value => value),
        description.map(value => value),
        name.map(value => value),
        streamingImageId,
        studioId
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[StreamingImageDescription]
    def name: Optional[StreamingImageName]
    def streamingImageId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, StreamingImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, StreamingImageName] =
      AwsError.unwrapOptionField("name", name)
    def getStreamingImageId: ZIO[Any, Nothing, String] =
      ZIO.succeed(streamingImageId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest
  ) extends zio.aws.nimble.model.UpdateStreamingImageRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val description: Optional[StreamingImageDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.nimble.model.primitives.StreamingImageDescription(value)
        )
    override val name: Optional[StreamingImageName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.nimble.model.primitives.StreamingImageName(value))
    override val streamingImageId: String = impl.streamingImageId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest
  ): zio.aws.nimble.model.UpdateStreamingImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
