package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StudioMembership(
    identityStoreId: Optional[String] = Optional.Absent,
    persona: Optional[zio.aws.nimble.model.StudioPersona] = Optional.Absent,
    principalId: Optional[String] = Optional.Absent,
    sid: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StudioMembership = {
    import StudioMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StudioMembership
      .builder()
      .optionallyWith(identityStoreId.map(value => value: java.lang.String))(
        _.identityStoreId
      )
      .optionallyWith(persona.map(value => value.unwrap))(_.persona)
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(sid.map(value => value: java.lang.String))(_.sid)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StudioMembership.ReadOnly =
    zio.aws.nimble.model.StudioMembership.wrap(buildAwsValue())
}
object StudioMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StudioMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StudioMembership =
      zio.aws.nimble.model.StudioMembership(
        identityStoreId.map(value => value),
        persona.map(value => value),
        principalId.map(value => value),
        sid.map(value => value)
      )
    def identityStoreId: Optional[String]
    def persona: Optional[zio.aws.nimble.model.StudioPersona]
    def principalId: Optional[String]
    def sid: Optional[String]
    def getIdentityStoreId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identityStoreId", identityStoreId)
    def getPersona: ZIO[Any, AwsError, zio.aws.nimble.model.StudioPersona] =
      AwsError.unwrapOptionField("persona", persona)
    def getPrincipalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getSid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sid", sid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StudioMembership
  ) extends zio.aws.nimble.model.StudioMembership.ReadOnly {
    override val identityStoreId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.identityStoreId())
      .map(value => value: String)
    override val persona: Optional[zio.aws.nimble.model.StudioPersona] =
      zio.aws.core.internal
        .optionalFromNullable(impl.persona())
        .map(value => zio.aws.nimble.model.StudioPersona.wrap(value))
    override val principalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: String)
    override val sid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sid())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StudioMembership
  ): zio.aws.nimble.model.StudioMembership.ReadOnly = new Wrapper(impl)
}
