package zio.aws.nimble.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{StreamingSessionId, Timestamp}
import scala.jdk.CollectionConverters._
final case class StreamingSessionBackup(
    arn: Optional[String] = Optional.Absent,
    backupId: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    launchProfileId: Optional[String] = Optional.Absent,
    ownedBy: Optional[String] = Optional.Absent,
    sessionId: Optional[StreamingSessionId] = Optional.Absent,
    state: Optional[zio.aws.nimble.model.StreamingSessionState] =
      Optional.Absent,
    statusCode: Optional[zio.aws.nimble.model.StreamingSessionStatusCode] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamingSessionBackup = {
    import StreamingSessionBackup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamingSessionBackup
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(backupId.map(value => value: java.lang.String))(
        _.backupId
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(launchProfileId.map(value => value: java.lang.String))(
        _.launchProfileId
      )
      .optionallyWith(ownedBy.map(value => value: java.lang.String))(_.ownedBy)
      .optionallyWith(
        sessionId.map(value =>
          StreamingSessionId.unwrap(value): java.lang.String
        )
      )(_.sessionId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamingSessionBackup.ReadOnly =
    zio.aws.nimble.model.StreamingSessionBackup.wrap(buildAwsValue())
}
object StreamingSessionBackup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamingSessionBackup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamingSessionBackup =
      zio.aws.nimble.model.StreamingSessionBackup(
        arn.map(value => value),
        backupId.map(value => value),
        createdAt.map(value => value),
        launchProfileId.map(value => value),
        ownedBy.map(value => value),
        sessionId.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[String]
    def backupId: Optional[String]
    def createdAt: Optional[Timestamp]
    def launchProfileId: Optional[String]
    def ownedBy: Optional[String]
    def sessionId: Optional[StreamingSessionId]
    def state: Optional[zio.aws.nimble.model.StreamingSessionState]
    def statusCode: Optional[zio.aws.nimble.model.StreamingSessionStatusCode]
    def statusMessage: Optional[String]
    def tags: Optional[Map[String, String]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getBackupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupId", backupId)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLaunchProfileId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchProfileId", launchProfileId)
    def getOwnedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getSessionId: ZIO[Any, AwsError, StreamingSessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getState
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSessionState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSessionStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSessionBackup
  ) extends zio.aws.nimble.model.StreamingSessionBackup.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val backupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupId())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val launchProfileId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchProfileId())
      .map(value => value: String)
    override val ownedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownedBy())
      .map(value => value: String)
    override val sessionId: Optional[StreamingSessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.nimble.model.primitives.StreamingSessionId(value))
    override val state: Optional[zio.aws.nimble.model.StreamingSessionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.nimble.model.StreamingSessionState.wrap(value))
    override val statusCode
        : Optional[zio.aws.nimble.model.StreamingSessionStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.nimble.model.StreamingSessionStatusCode.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSessionBackup
  ): zio.aws.nimble.model.StreamingSessionBackup.ReadOnly = new Wrapper(impl)
}
