package zio.aws.nimble.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.StreamConfigurationMaxBackupsToRetain
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StreamConfigurationSessionBackup(
    maxBackupsToRetain: Optional[StreamConfigurationMaxBackupsToRetain] =
      Optional.Absent,
    mode: Optional[zio.aws.nimble.model.SessionBackupMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionBackup = {
    import StreamConfigurationSessionBackup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionBackup
      .builder()
      .optionallyWith(
        maxBackupsToRetain.map(value =>
          StreamConfigurationMaxBackupsToRetain.unwrap(value): Integer
        )
      )(_.maxBackupsToRetain)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.StreamConfigurationSessionBackup.ReadOnly =
    zio.aws.nimble.model.StreamConfigurationSessionBackup.wrap(buildAwsValue())
}
object StreamConfigurationSessionBackup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionBackup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamConfigurationSessionBackup =
      zio.aws.nimble.model.StreamConfigurationSessionBackup(
        maxBackupsToRetain.map(value => value),
        mode.map(value => value)
      )
    def maxBackupsToRetain: Optional[StreamConfigurationMaxBackupsToRetain]
    def mode: Optional[zio.aws.nimble.model.SessionBackupMode]
    def getMaxBackupsToRetain
        : ZIO[Any, AwsError, StreamConfigurationMaxBackupsToRetain] =
      AwsError.unwrapOptionField("maxBackupsToRetain", maxBackupsToRetain)
    def getMode: ZIO[Any, AwsError, zio.aws.nimble.model.SessionBackupMode] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionBackup
  ) extends zio.aws.nimble.model.StreamConfigurationSessionBackup.ReadOnly {
    override val maxBackupsToRetain
        : Optional[StreamConfigurationMaxBackupsToRetain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxBackupsToRetain())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StreamConfigurationMaxBackupsToRetain(value)
        )
    override val mode: Optional[zio.aws.nimble.model.SessionBackupMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.nimble.model.SessionBackupMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionBackup
  ): zio.aws.nimble.model.StreamConfigurationSessionBackup.ReadOnly =
    new Wrapper(impl)
}
