package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopStreamingSessionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    sessionId: String,
    studioId: String,
    volumeRetentionMode: Optional[zio.aws.nimble.model.VolumeRetentionMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest = {
    import StopStreamingSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .sessionId(sessionId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .optionallyWith(volumeRetentionMode.map(value => value.unwrap))(
        _.volumeRetentionMode
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StopStreamingSessionRequest.ReadOnly =
    zio.aws.nimble.model.StopStreamingSessionRequest.wrap(buildAwsValue())
}
object StopStreamingSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StopStreamingSessionRequest =
      zio.aws.nimble.model.StopStreamingSessionRequest(
        clientToken.map(value => value),
        sessionId,
        studioId,
        volumeRetentionMode.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def sessionId: String
    def studioId: String
    def volumeRetentionMode: Optional[zio.aws.nimble.model.VolumeRetentionMode]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSessionId: ZIO[Any, Nothing, String] = ZIO.succeed(sessionId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getVolumeRetentionMode
        : ZIO[Any, AwsError, zio.aws.nimble.model.VolumeRetentionMode] =
      AwsError.unwrapOptionField("volumeRetentionMode", volumeRetentionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest
  ) extends zio.aws.nimble.model.StopStreamingSessionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val sessionId: String = impl.sessionId(): String
    override val studioId: String = impl.studioId(): String
    override val volumeRetentionMode
        : Optional[zio.aws.nimble.model.VolumeRetentionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeRetentionMode())
        .map(value => zio.aws.nimble.model.VolumeRetentionMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest
  ): zio.aws.nimble.model.StopStreamingSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
