package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartStreamingSessionRequest(
    backupId: Optional[String] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    sessionId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StartStreamingSessionRequest = {
    import StartStreamingSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StartStreamingSessionRequest
      .builder()
      .optionallyWith(backupId.map(value => value: java.lang.String))(
        _.backupId
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .sessionId(sessionId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StartStreamingSessionRequest.ReadOnly =
    zio.aws.nimble.model.StartStreamingSessionRequest.wrap(buildAwsValue())
}
object StartStreamingSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StartStreamingSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StartStreamingSessionRequest =
      zio.aws.nimble.model.StartStreamingSessionRequest(
        backupId.map(value => value),
        clientToken.map(value => value),
        sessionId,
        studioId
      )
    def backupId: Optional[String]
    def clientToken: Optional[ClientToken]
    def sessionId: String
    def studioId: String
    def getBackupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupId", backupId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSessionId: ZIO[Any, Nothing, String] = ZIO.succeed(sessionId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StartStreamingSessionRequest
  ) extends zio.aws.nimble.model.StartStreamingSessionRequest.ReadOnly {
    override val backupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupId())
      .map(value => value: String)
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val sessionId: String = impl.sessionId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StartStreamingSessionRequest
  ): zio.aws.nimble.model.StartStreamingSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
