package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait SessionBackupMode {
  def unwrap: software.amazon.awssdk.services.nimble.model.SessionBackupMode
}
object SessionBackupMode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.SessionBackupMode
  ): zio.aws.nimble.model.SessionBackupMode = value match {
    case software.amazon.awssdk.services.nimble.model.SessionBackupMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.SessionBackupMode.AUTOMATIC =>
      val r = AUTOMATIC
      r
    case software.amazon.awssdk.services.nimble.model.SessionBackupMode.DEACTIVATED =>
      val r = DEACTIVATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.SessionBackupMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.SessionBackupMode =
      software.amazon.awssdk.services.nimble.model.SessionBackupMode.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATIC extends zio.aws.nimble.model.SessionBackupMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.SessionBackupMode =
      software.amazon.awssdk.services.nimble.model.SessionBackupMode.AUTOMATIC
  }
  case object DEACTIVATED extends zio.aws.nimble.model.SessionBackupMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.SessionBackupMode =
      software.amazon.awssdk.services.nimble.model.SessionBackupMode.DEACTIVATED
  }
}
