package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutLaunchProfileMembersRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    identityStoreId: String,
    launchProfileId: String,
    members: Iterable[zio.aws.nimble.model.NewLaunchProfileMember],
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersRequest = {
    import PutLaunchProfileMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .identityStoreId(identityStoreId: java.lang.String)
      .launchProfileId(launchProfileId: java.lang.String)
      .members(members.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.PutLaunchProfileMembersRequest.ReadOnly =
    zio.aws.nimble.model.PutLaunchProfileMembersRequest.wrap(buildAwsValue())
}
object PutLaunchProfileMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.PutLaunchProfileMembersRequest =
      zio.aws.nimble.model.PutLaunchProfileMembersRequest(
        clientToken.map(value => value),
        identityStoreId,
        launchProfileId,
        members.map { item =>
          item.asEditable
        },
        studioId
      )
    def clientToken: Optional[ClientToken]
    def identityStoreId: String
    def launchProfileId: String
    def members: List[zio.aws.nimble.model.NewLaunchProfileMember.ReadOnly]
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getIdentityStoreId: ZIO[Any, Nothing, String] =
      ZIO.succeed(identityStoreId)
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getMembers: ZIO[Any, Nothing, List[
      zio.aws.nimble.model.NewLaunchProfileMember.ReadOnly
    ]] = ZIO.succeed(members)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersRequest
  ) extends zio.aws.nimble.model.PutLaunchProfileMembersRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val identityStoreId: String = impl.identityStoreId(): String
    override val launchProfileId: String = impl.launchProfileId(): String
    override val members
        : List[zio.aws.nimble.model.NewLaunchProfileMember.ReadOnly] = impl
      .members()
      .asScala
      .map { item =>
        zio.aws.nimble.model.NewLaunchProfileMember.wrap(item)
      }
      .toList
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersRequest
  ): zio.aws.nimble.model.PutLaunchProfileMembersRequest.ReadOnly = new Wrapper(
    impl
  )
}
