package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamingSessionBackupsResponse(
    nextToken: Optional[String] = Optional.Absent,
    streamingSessionBackups: Optional[
      Iterable[zio.aws.nimble.model.StreamingSessionBackup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsResponse = {
    import ListStreamingSessionBackupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        streamingSessionBackups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamingSessionBackups)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.ListStreamingSessionBackupsResponse.ReadOnly =
    zio.aws.nimble.model.ListStreamingSessionBackupsResponse
      .wrap(buildAwsValue())
}
object ListStreamingSessionBackupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStreamingSessionBackupsResponse =
      zio.aws.nimble.model.ListStreamingSessionBackupsResponse(
        nextToken.map(value => value),
        streamingSessionBackups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def streamingSessionBackups
        : Optional[List[zio.aws.nimble.model.StreamingSessionBackup.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStreamingSessionBackups: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StreamingSessionBackup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "streamingSessionBackups",
      streamingSessionBackups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsResponse
  ) extends zio.aws.nimble.model.ListStreamingSessionBackupsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val streamingSessionBackups
        : Optional[List[zio.aws.nimble.model.StreamingSessionBackup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingSessionBackups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StreamingSessionBackup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsResponse
  ): zio.aws.nimble.model.ListStreamingSessionBackupsResponse.ReadOnly =
    new Wrapper(impl)
}
