package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  LaunchProfileName,
  SecurityGroupId,
  LaunchPurpose,
  LaunchProfileId,
  LaunchProfileProtocolVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchProfileInitialization(
    activeDirectory: Optional[
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory
    ] = Optional.Absent,
    ec2SecurityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    launchProfileId: Optional[LaunchProfileId] = Optional.Absent,
    launchProfileProtocolVersion: Optional[LaunchProfileProtocolVersion] =
      Optional.Absent,
    launchPurpose: Optional[LaunchPurpose] = Optional.Absent,
    name: Optional[LaunchProfileName] = Optional.Absent,
    platform: Optional[zio.aws.nimble.model.LaunchProfilePlatform] =
      Optional.Absent,
    systemInitializationScripts: Optional[
      Iterable[zio.aws.nimble.model.LaunchProfileInitializationScript]
    ] = Optional.Absent,
    userInitializationScripts: Optional[
      Iterable[zio.aws.nimble.model.LaunchProfileInitializationScript]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization = {
    import LaunchProfileInitialization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization
      .builder()
      .optionallyWith(activeDirectory.map(value => value.buildAwsValue()))(
        _.activeDirectory
      )
      .optionallyWith(
        ec2SecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SecurityGroupIds)
      .optionallyWith(
        launchProfileId.map(value =>
          LaunchProfileId.unwrap(value): java.lang.String
        )
      )(_.launchProfileId)
      .optionallyWith(
        launchProfileProtocolVersion.map(value =>
          LaunchProfileProtocolVersion.unwrap(value): java.lang.String
        )
      )(_.launchProfileProtocolVersion)
      .optionallyWith(
        launchPurpose.map(value =>
          LaunchPurpose.unwrap(value): java.lang.String
        )
      )(_.launchPurpose)
      .optionallyWith(
        name.map(value => LaunchProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        systemInitializationScripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.systemInitializationScripts)
      .optionallyWith(
        userInitializationScripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userInitializationScripts)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.LaunchProfileInitialization.ReadOnly =
    zio.aws.nimble.model.LaunchProfileInitialization.wrap(buildAwsValue())
}
object LaunchProfileInitialization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.LaunchProfileInitialization =
      zio.aws.nimble.model.LaunchProfileInitialization(
        activeDirectory.map(value => value.asEditable),
        ec2SecurityGroupIds.map(value => value),
        launchProfileId.map(value => value),
        launchProfileProtocolVersion.map(value => value),
        launchPurpose.map(value => value),
        name.map(value => value),
        platform.map(value => value),
        systemInitializationScripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userInitializationScripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def activeDirectory: Optional[
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly
    ]
    def ec2SecurityGroupIds: Optional[List[SecurityGroupId]]
    def launchProfileId: Optional[LaunchProfileId]
    def launchProfileProtocolVersion: Optional[LaunchProfileProtocolVersion]
    def launchPurpose: Optional[LaunchPurpose]
    def name: Optional[LaunchProfileName]
    def platform: Optional[zio.aws.nimble.model.LaunchProfilePlatform]
    def systemInitializationScripts: Optional[
      List[zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly]
    ]
    def userInitializationScripts: Optional[
      List[zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly]
    ]
    def getActiveDirectory: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly
    ] = AwsError.unwrapOptionField("activeDirectory", activeDirectory)
    def getEc2SecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("ec2SecurityGroupIds", ec2SecurityGroupIds)
    def getLaunchProfileId: ZIO[Any, AwsError, LaunchProfileId] =
      AwsError.unwrapOptionField("launchProfileId", launchProfileId)
    def getLaunchProfileProtocolVersion
        : ZIO[Any, AwsError, LaunchProfileProtocolVersion] =
      AwsError.unwrapOptionField(
        "launchProfileProtocolVersion",
        launchProfileProtocolVersion
      )
    def getLaunchPurpose: ZIO[Any, AwsError, LaunchPurpose] =
      AwsError.unwrapOptionField("launchPurpose", launchPurpose)
    def getName: ZIO[Any, AwsError, LaunchProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfilePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSystemInitializationScripts: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "systemInitializationScripts",
      systemInitializationScripts
    )
    def getUserInitializationScripts: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userInitializationScripts",
      userInitializationScripts
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization
  ) extends zio.aws.nimble.model.LaunchProfileInitialization.ReadOnly {
    override val activeDirectory: Optional[
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activeDirectory())
      .map(value =>
        zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory
          .wrap(value)
      )
    override val ec2SecurityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val launchProfileId: Optional[LaunchProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchProfileId())
        .map(value => zio.aws.nimble.model.primitives.LaunchProfileId(value))
    override val launchProfileProtocolVersion
        : Optional[LaunchProfileProtocolVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.launchProfileProtocolVersion())
      .map(value =>
        zio.aws.nimble.model.primitives.LaunchProfileProtocolVersion(value)
      )
    override val launchPurpose: Optional[LaunchPurpose] = zio.aws.core.internal
      .optionalFromNullable(impl.launchPurpose())
      .map(value => zio.aws.nimble.model.primitives.LaunchPurpose(value))
    override val name: Optional[LaunchProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.nimble.model.primitives.LaunchProfileName(value))
    override val platform
        : Optional[zio.aws.nimble.model.LaunchProfilePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.nimble.model.LaunchProfilePlatform.wrap(value))
    override val systemInitializationScripts: Optional[
      List[zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.systemInitializationScripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.LaunchProfileInitializationScript.wrap(item)
        }.toList
      )
    override val userInitializationScripts: Optional[
      List[zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userInitializationScripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.LaunchProfileInitializationScript.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization
  ): zio.aws.nimble.model.LaunchProfileInitialization.ReadOnly = new Wrapper(
    impl
  )
}
