package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStreamingSessionBackupRequest(
    backupId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupRequest = {
    import GetStreamingSessionBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupRequest
      .builder()
      .backupId(backupId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.GetStreamingSessionBackupRequest.ReadOnly =
    zio.aws.nimble.model.GetStreamingSessionBackupRequest.wrap(buildAwsValue())
}
object GetStreamingSessionBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStreamingSessionBackupRequest =
      zio.aws.nimble.model.GetStreamingSessionBackupRequest(backupId, studioId)
    def backupId: String
    def studioId: String
    def getBackupId: ZIO[Any, Nothing, String] = ZIO.succeed(backupId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupRequest
  ) extends zio.aws.nimble.model.GetStreamingSessionBackupRequest.ReadOnly {
    override val backupId: String = impl.backupId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupRequest
  ): zio.aws.nimble.model.GetStreamingSessionBackupRequest.ReadOnly =
    new Wrapper(impl)
}
