package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLaunchProfileInitializationResponse(
    launchProfileInitialization: Optional[
      zio.aws.nimble.model.LaunchProfileInitialization
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationResponse = {
    import GetLaunchProfileInitializationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationResponse
      .builder()
      .optionallyWith(
        launchProfileInitialization.map(value => value.buildAwsValue())
      )(_.launchProfileInitialization)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.GetLaunchProfileInitializationResponse.ReadOnly =
    zio.aws.nimble.model.GetLaunchProfileInitializationResponse
      .wrap(buildAwsValue())
}
object GetLaunchProfileInitializationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.nimble.model.GetLaunchProfileInitializationResponse =
      zio.aws.nimble.model.GetLaunchProfileInitializationResponse(
        launchProfileInitialization.map(value => value.asEditable)
      )
    def launchProfileInitialization
        : Optional[zio.aws.nimble.model.LaunchProfileInitialization.ReadOnly]
    def getLaunchProfileInitialization: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.LaunchProfileInitialization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchProfileInitialization",
      launchProfileInitialization
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationResponse
  ) extends zio.aws.nimble.model.GetLaunchProfileInitializationResponse.ReadOnly {
    override val launchProfileInitialization
        : Optional[zio.aws.nimble.model.LaunchProfileInitialization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchProfileInitialization())
        .map(value =>
          zio.aws.nimble.model.LaunchProfileInitialization.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationResponse
  ): zio.aws.nimble.model.GetLaunchProfileInitializationResponse.ReadOnly =
    new Wrapper(impl)
}
