package zio.aws.nimble.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{
  StreamingSessionStreamExpirationInSeconds,
  ClientToken
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateStreamingSessionStreamRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    expirationInSeconds: Optional[StreamingSessionStreamExpirationInSeconds] =
      Optional.Absent,
    sessionId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamRequest = {
    import CreateStreamingSessionStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        expirationInSeconds.map(value =>
          StreamingSessionStreamExpirationInSeconds.unwrap(value): Integer
        )
      )(_.expirationInSeconds)
      .sessionId(sessionId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.CreateStreamingSessionStreamRequest.ReadOnly =
    zio.aws.nimble.model.CreateStreamingSessionStreamRequest
      .wrap(buildAwsValue())
}
object CreateStreamingSessionStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStreamingSessionStreamRequest =
      zio.aws.nimble.model.CreateStreamingSessionStreamRequest(
        clientToken.map(value => value),
        expirationInSeconds.map(value => value),
        sessionId,
        studioId
      )
    def clientToken: Optional[ClientToken]
    def expirationInSeconds: Optional[StreamingSessionStreamExpirationInSeconds]
    def sessionId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExpirationInSeconds
        : ZIO[Any, AwsError, StreamingSessionStreamExpirationInSeconds] =
      AwsError.unwrapOptionField("expirationInSeconds", expirationInSeconds)
    def getSessionId: ZIO[Any, Nothing, String] = ZIO.succeed(sessionId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamRequest
  ) extends zio.aws.nimble.model.CreateStreamingSessionStreamRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val expirationInSeconds
        : Optional[StreamingSessionStreamExpirationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expirationInSeconds())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StreamingSessionStreamExpirationInSeconds(value)
        )
    override val sessionId: String = impl.sessionId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamRequest
  ): zio.aws.nimble.model.CreateStreamingSessionStreamRequest.ReadOnly =
    new Wrapper(impl)
}
