package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStreamingSessionResponse(
    session: Optional[zio.aws.nimble.model.StreamingSession] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStreamingSessionResponse = {
    import CreateStreamingSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStreamingSessionResponse
      .builder()
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStreamingSessionResponse.ReadOnly =
    zio.aws.nimble.model.CreateStreamingSessionResponse.wrap(buildAwsValue())
}
object CreateStreamingSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStreamingSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStreamingSessionResponse =
      zio.aws.nimble.model
        .CreateStreamingSessionResponse(session.map(value => value.asEditable))
    def session: Optional[zio.aws.nimble.model.StreamingSession.ReadOnly]
    def getSession
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSession.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingSessionResponse
  ) extends zio.aws.nimble.model.CreateStreamingSessionResponse.ReadOnly {
    override val session
        : Optional[zio.aws.nimble.model.StreamingSession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.session())
        .map(value => zio.aws.nimble.model.StreamingSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingSessionResponse
  ): zio.aws.nimble.model.CreateStreamingSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
