package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{StreamingImageId, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStreamingSessionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    ec2InstanceType: Optional[zio.aws.nimble.model.StreamingInstanceType] =
      Optional.Absent,
    launchProfileId: String,
    ownedBy: Optional[String] = Optional.Absent,
    streamingImageId: Optional[StreamingImageId] = Optional.Absent,
    studioId: String,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStreamingSessionRequest = {
    import CreateStreamingSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStreamingSessionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(ec2InstanceType.map(value => value.unwrap))(
        _.ec2InstanceType
      )
      .launchProfileId(launchProfileId: java.lang.String)
      .optionallyWith(ownedBy.map(value => value: java.lang.String))(_.ownedBy)
      .optionallyWith(
        streamingImageId.map(value =>
          StreamingImageId.unwrap(value): java.lang.String
        )
      )(_.streamingImageId)
      .studioId(studioId: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStreamingSessionRequest.ReadOnly =
    zio.aws.nimble.model.CreateStreamingSessionRequest.wrap(buildAwsValue())
}
object CreateStreamingSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStreamingSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStreamingSessionRequest =
      zio.aws.nimble.model.CreateStreamingSessionRequest(
        clientToken.map(value => value),
        ec2InstanceType.map(value => value),
        launchProfileId,
        ownedBy.map(value => value),
        streamingImageId.map(value => value),
        studioId,
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def ec2InstanceType: Optional[zio.aws.nimble.model.StreamingInstanceType]
    def launchProfileId: String
    def ownedBy: Optional[String]
    def streamingImageId: Optional[StreamingImageId]
    def studioId: String
    def tags: Optional[Map[String, String]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEc2InstanceType
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingInstanceType] =
      AwsError.unwrapOptionField("ec2InstanceType", ec2InstanceType)
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getOwnedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getStreamingImageId: ZIO[Any, AwsError, StreamingImageId] =
      AwsError.unwrapOptionField("streamingImageId", streamingImageId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingSessionRequest
  ) extends zio.aws.nimble.model.CreateStreamingSessionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val ec2InstanceType
        : Optional[zio.aws.nimble.model.StreamingInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceType())
        .map(value => zio.aws.nimble.model.StreamingInstanceType.wrap(value))
    override val launchProfileId: String = impl.launchProfileId(): String
    override val ownedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownedBy())
      .map(value => value: String)
    override val streamingImageId: Optional[StreamingImageId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingImageId())
        .map(value => zio.aws.nimble.model.primitives.StreamingImageId(value))
    override val studioId: String = impl.studioId(): String
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingSessionRequest
  ): zio.aws.nimble.model.CreateStreamingSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
