package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  ActiveDirectoryOrganizationalUnitDistinguishedName,
  DirectoryId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActiveDirectoryConfiguration(
    computerAttributes: Optional[
      Iterable[zio.aws.nimble.model.ActiveDirectoryComputerAttribute]
    ] = Optional.Absent,
    directoryId: Optional[DirectoryId] = Optional.Absent,
    organizationalUnitDistinguishedName: Optional[
      ActiveDirectoryOrganizationalUnitDistinguishedName
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration = {
    import ActiveDirectoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration
      .builder()
      .optionallyWith(
        computerAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computerAttributes)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(
        organizationalUnitDistinguishedName.map(value =>
          ActiveDirectoryOrganizationalUnitDistinguishedName.unwrap(
            value
          ): java.lang.String
        )
      )(_.organizationalUnitDistinguishedName)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly =
    zio.aws.nimble.model.ActiveDirectoryConfiguration.wrap(buildAwsValue())
}
object ActiveDirectoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ActiveDirectoryConfiguration =
      zio.aws.nimble.model.ActiveDirectoryConfiguration(
        computerAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        directoryId.map(value => value),
        organizationalUnitDistinguishedName.map(value => value)
      )
    def computerAttributes: Optional[
      List[zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly]
    ]
    def directoryId: Optional[DirectoryId]
    def organizationalUnitDistinguishedName
        : Optional[ActiveDirectoryOrganizationalUnitDistinguishedName]
    def getComputerAttributes: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("computerAttributes", computerAttributes)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getOrganizationalUnitDistinguishedName: ZIO[
      Any,
      AwsError,
      ActiveDirectoryOrganizationalUnitDistinguishedName
    ] = AwsError.unwrapOptionField(
      "organizationalUnitDistinguishedName",
      organizationalUnitDistinguishedName
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration
  ) extends zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly {
    override val computerAttributes: Optional[
      List[zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.computerAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.ActiveDirectoryComputerAttribute.wrap(item)
        }.toList
      )
    override val directoryId: Optional[DirectoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => zio.aws.nimble.model.primitives.DirectoryId(value))
    override val organizationalUnitDistinguishedName
        : Optional[ActiveDirectoryOrganizationalUnitDistinguishedName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitDistinguishedName())
        .map(value =>
          zio.aws.nimble.model.primitives
            .ActiveDirectoryOrganizationalUnitDistinguishedName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration
  ): zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
