package zio.aws.nimble
import zio.aws.nimble.model.GetStudioResponse.ReadOnly
import zio.aws.nimble.model.{
  GetLaunchProfileRequest,
  ListEulaAcceptancesRequest,
  CreateLaunchProfileRequest,
  GetLaunchProfileInitializationRequest,
  ListLaunchProfilesRequest,
  GetEulaRequest,
  DeleteStreamingImageRequest,
  ListStreamingSessionsRequest,
  DeleteStreamingSessionRequest,
  GetStudioMemberRequest,
  GetStreamingSessionStreamRequest,
  GetLaunchProfileDetailsRequest,
  CreateStudioRequest,
  ListStreamingImagesRequest,
  GetStreamingImageRequest,
  GetStudioRequest,
  StartStudioSsoConfigurationRepairRequest,
  ListEulasRequest,
  GetStreamingSessionBackupRequest,
  ListTagsForResourceRequest,
  CreateStreamingSessionStreamRequest,
  AcceptEulasRequest,
  GetStudioComponentRequest,
  DeleteLaunchProfileRequest,
  PutLaunchProfileMembersRequest,
  ListStudioComponentsRequest,
  UpdateStudioRequest,
  ListLaunchProfileMembersRequest,
  UpdateLaunchProfileRequest,
  ListStudiosRequest,
  PutStudioMembersRequest,
  UpdateStudioComponentRequest,
  UntagResourceRequest,
  DeleteStudioComponentRequest,
  CreateStreamingSessionRequest,
  ListStreamingSessionBackupsRequest,
  GetLaunchProfileMemberRequest,
  ListStudioMembersRequest,
  UpdateLaunchProfileMemberRequest,
  DeleteLaunchProfileMemberRequest,
  CreateStudioComponentRequest,
  DeleteStudioMemberRequest,
  CreateStreamingImageRequest,
  TagResourceRequest,
  UpdateStreamingImageRequest,
  DeleteStudioRequest,
  StartStreamingSessionRequest,
  GetStreamingSessionRequest,
  StopStreamingSessionRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.nimble.NimbleAsyncClient
import zio.stream.ZStream
object NimbleMock extends Mock[Nimble] {
  object DeleteStreamingImage
      extends Effect[
        DeleteStreamingImageRequest,
        AwsError,
        zio.aws.nimble.model.DeleteStreamingImageResponse.ReadOnly
      ]
  object ListLaunchProfileMembers
      extends Stream[
        ListLaunchProfileMembersRequest,
        AwsError,
        zio.aws.nimble.model.LaunchProfileMembership.ReadOnly
      ]
  object ListLaunchProfileMembersPaginated
      extends Effect[
        ListLaunchProfileMembersRequest,
        AwsError,
        zio.aws.nimble.model.ListLaunchProfileMembersResponse.ReadOnly
      ]
  object CreateStudio
      extends Effect[
        CreateStudioRequest,
        AwsError,
        zio.aws.nimble.model.CreateStudioResponse.ReadOnly
      ]
  object UpdateLaunchProfile
      extends Effect[
        UpdateLaunchProfileRequest,
        AwsError,
        zio.aws.nimble.model.UpdateLaunchProfileResponse.ReadOnly
      ]
  object CreateLaunchProfile
      extends Effect[
        CreateLaunchProfileRequest,
        AwsError,
        zio.aws.nimble.model.CreateLaunchProfileResponse.ReadOnly
      ]
  object AcceptEulas
      extends Effect[
        AcceptEulasRequest,
        AwsError,
        zio.aws.nimble.model.AcceptEulasResponse.ReadOnly
      ]
  object GetEula
      extends Effect[
        GetEulaRequest,
        AwsError,
        zio.aws.nimble.model.GetEulaResponse.ReadOnly
      ]
  object GetLaunchProfile
      extends Effect[
        GetLaunchProfileRequest,
        AwsError,
        zio.aws.nimble.model.GetLaunchProfileResponse.ReadOnly
      ]
  object ListEulaAcceptances
      extends Stream[
        ListEulaAcceptancesRequest,
        AwsError,
        zio.aws.nimble.model.EulaAcceptance.ReadOnly
      ]
  object ListEulaAcceptancesPaginated
      extends Effect[
        ListEulaAcceptancesRequest,
        AwsError,
        zio.aws.nimble.model.ListEulaAcceptancesResponse.ReadOnly
      ]
  object DeleteStreamingSession
      extends Effect[
        DeleteStreamingSessionRequest,
        AwsError,
        zio.aws.nimble.model.DeleteStreamingSessionResponse.ReadOnly
      ]
  object DeleteLaunchProfile
      extends Effect[
        DeleteLaunchProfileRequest,
        AwsError,
        zio.aws.nimble.model.DeleteLaunchProfileResponse.ReadOnly
      ]
  object GetStreamingImage
      extends Effect[
        GetStreamingImageRequest,
        AwsError,
        zio.aws.nimble.model.GetStreamingImageResponse.ReadOnly
      ]
  object UpdateStudioComponent
      extends Effect[
        UpdateStudioComponentRequest,
        AwsError,
        zio.aws.nimble.model.UpdateStudioComponentResponse.ReadOnly
      ]
  object ListStudioComponents
      extends Stream[
        ListStudioComponentsRequest,
        AwsError,
        zio.aws.nimble.model.StudioComponent.ReadOnly
      ]
  object ListStudioComponentsPaginated
      extends Effect[
        ListStudioComponentsRequest,
        AwsError,
        zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly
      ]
  object GetStudio extends Effect[GetStudioRequest, AwsError, ReadOnly]
  object ListStudioMembers
      extends Stream[
        ListStudioMembersRequest,
        AwsError,
        zio.aws.nimble.model.StudioMembership.ReadOnly
      ]
  object ListStudioMembersPaginated
      extends Effect[
        ListStudioMembersRequest,
        AwsError,
        zio.aws.nimble.model.ListStudioMembersResponse.ReadOnly
      ]
  object ListLaunchProfiles
      extends Stream[
        ListLaunchProfilesRequest,
        AwsError,
        zio.aws.nimble.model.LaunchProfile.ReadOnly
      ]
  object ListLaunchProfilesPaginated
      extends Effect[
        ListLaunchProfilesRequest,
        AwsError,
        zio.aws.nimble.model.ListLaunchProfilesResponse.ReadOnly
      ]
  object DeleteStudioComponent
      extends Effect[
        DeleteStudioComponentRequest,
        AwsError,
        zio.aws.nimble.model.DeleteStudioComponentResponse.ReadOnly
      ]
  object CreateStreamingImage
      extends Effect[
        CreateStreamingImageRequest,
        AwsError,
        zio.aws.nimble.model.CreateStreamingImageResponse.ReadOnly
      ]
  object GetStudioMember
      extends Effect[
        GetStudioMemberRequest,
        AwsError,
        zio.aws.nimble.model.GetStudioMemberResponse.ReadOnly
      ]
  object UpdateStreamingImage
      extends Effect[
        UpdateStreamingImageRequest,
        AwsError,
        zio.aws.nimble.model.UpdateStreamingImageResponse.ReadOnly
      ]
  object UpdateStudio
      extends Effect[
        UpdateStudioRequest,
        AwsError,
        zio.aws.nimble.model.UpdateStudioResponse.ReadOnly
      ]
  object UpdateLaunchProfileMember
      extends Effect[
        UpdateLaunchProfileMemberRequest,
        AwsError,
        zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.ReadOnly
      ]
  object GetStreamingSessionBackup
      extends Effect[
        GetStreamingSessionBackupRequest,
        AwsError,
        zio.aws.nimble.model.GetStreamingSessionBackupResponse.ReadOnly
      ]
  object ListStudios
      extends Stream[
        ListStudiosRequest,
        AwsError,
        zio.aws.nimble.model.Studio.ReadOnly
      ]
  object ListStudiosPaginated
      extends Effect[
        ListStudiosRequest,
        AwsError,
        zio.aws.nimble.model.ListStudiosResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.nimble.model.UntagResourceResponse.ReadOnly
      ]
  object ListStreamingSessions
      extends Stream[
        ListStreamingSessionsRequest,
        AwsError,
        zio.aws.nimble.model.StreamingSession.ReadOnly
      ]
  object ListStreamingSessionsPaginated
      extends Effect[
        ListStreamingSessionsRequest,
        AwsError,
        zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly
      ]
  object ListStreamingImages
      extends Stream[
        ListStreamingImagesRequest,
        AwsError,
        zio.aws.nimble.model.StreamingImage.ReadOnly
      ]
  object ListStreamingImagesPaginated
      extends Effect[
        ListStreamingImagesRequest,
        AwsError,
        zio.aws.nimble.model.ListStreamingImagesResponse.ReadOnly
      ]
  object PutStudioMembers
      extends Effect[
        PutStudioMembersRequest,
        AwsError,
        zio.aws.nimble.model.PutStudioMembersResponse.ReadOnly
      ]
  object ListEulas
      extends Stream[
        ListEulasRequest,
        AwsError,
        zio.aws.nimble.model.Eula.ReadOnly
      ]
  object ListEulasPaginated
      extends Effect[
        ListEulasRequest,
        AwsError,
        zio.aws.nimble.model.ListEulasResponse.ReadOnly
      ]
  object StartStreamingSession
      extends Effect[
        StartStreamingSessionRequest,
        AwsError,
        zio.aws.nimble.model.StartStreamingSessionResponse.ReadOnly
      ]
  object GetStreamingSessionStream
      extends Effect[
        GetStreamingSessionStreamRequest,
        AwsError,
        zio.aws.nimble.model.GetStreamingSessionStreamResponse.ReadOnly
      ]
  object CreateStreamingSession
      extends Effect[
        CreateStreamingSessionRequest,
        AwsError,
        zio.aws.nimble.model.CreateStreamingSessionResponse.ReadOnly
      ]
  object GetStreamingSession
      extends Effect[
        GetStreamingSessionRequest,
        AwsError,
        zio.aws.nimble.model.GetStreamingSessionResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.nimble.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetLaunchProfileInitialization
      extends Effect[
        GetLaunchProfileInitializationRequest,
        AwsError,
        zio.aws.nimble.model.GetLaunchProfileInitializationResponse.ReadOnly
      ]
  object DeleteStudio
      extends Effect[
        DeleteStudioRequest,
        AwsError,
        zio.aws.nimble.model.DeleteStudioResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.nimble.model.TagResourceResponse.ReadOnly
      ]
  object PutLaunchProfileMembers
      extends Effect[
        PutLaunchProfileMembersRequest,
        AwsError,
        zio.aws.nimble.model.PutLaunchProfileMembersResponse.ReadOnly
      ]
  object GetStudioComponent
      extends Effect[
        GetStudioComponentRequest,
        AwsError,
        zio.aws.nimble.model.GetStudioComponentResponse.ReadOnly
      ]
  object GetLaunchProfileMember
      extends Effect[
        GetLaunchProfileMemberRequest,
        AwsError,
        zio.aws.nimble.model.GetLaunchProfileMemberResponse.ReadOnly
      ]
  object DeleteStudioMember
      extends Effect[
        DeleteStudioMemberRequest,
        AwsError,
        zio.aws.nimble.model.DeleteStudioMemberResponse.ReadOnly
      ]
  object CreateStudioComponent
      extends Effect[
        CreateStudioComponentRequest,
        AwsError,
        zio.aws.nimble.model.CreateStudioComponentResponse.ReadOnly
      ]
  object CreateStreamingSessionStream
      extends Effect[
        CreateStreamingSessionStreamRequest,
        AwsError,
        zio.aws.nimble.model.CreateStreamingSessionStreamResponse.ReadOnly
      ]
  object StartStudioSSOConfigurationRepair
      extends Effect[
        StartStudioSsoConfigurationRepairRequest,
        AwsError,
        zio.aws.nimble.model.StartStudioSsoConfigurationRepairResponse.ReadOnly
      ]
  object DeleteLaunchProfileMember
      extends Effect[
        DeleteLaunchProfileMemberRequest,
        AwsError,
        zio.aws.nimble.model.DeleteLaunchProfileMemberResponse.ReadOnly
      ]
  object ListStreamingSessionBackups
      extends Stream[
        ListStreamingSessionBackupsRequest,
        AwsError,
        zio.aws.nimble.model.StreamingSessionBackup.ReadOnly
      ]
  object ListStreamingSessionBackupsPaginated
      extends Effect[
        ListStreamingSessionBackupsRequest,
        AwsError,
        zio.aws.nimble.model.ListStreamingSessionBackupsResponse.ReadOnly
      ]
  object GetLaunchProfileDetails
      extends Effect[
        GetLaunchProfileDetailsRequest,
        AwsError,
        zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly
      ]
  object StopStreamingSession
      extends Effect[
        StopStreamingSessionRequest,
        AwsError,
        zio.aws.nimble.model.StopStreamingSessionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Nimble] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Nimble] { rts =>
        zio.ZIO.succeed {
          new Nimble {
            val api: NimbleAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Nimble = this
            def deleteStreamingImage(request: DeleteStreamingImageRequest): IO[
              AwsError,
              zio.aws.nimble.model.DeleteStreamingImageResponse.ReadOnly
            ] = proxy(DeleteStreamingImage, request)
            def listLaunchProfileMembers(
                request: ListLaunchProfileMembersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.nimble.model.LaunchProfileMembership.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLaunchProfileMembers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLaunchProfileMembersPaginated(
                request: ListLaunchProfileMembersRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.ListLaunchProfileMembersResponse.ReadOnly
            ] = proxy(ListLaunchProfileMembersPaginated, request)
            def createStudio(request: CreateStudioRequest): IO[
              AwsError,
              zio.aws.nimble.model.CreateStudioResponse.ReadOnly
            ] = proxy(CreateStudio, request)
            def updateLaunchProfile(request: UpdateLaunchProfileRequest): IO[
              AwsError,
              zio.aws.nimble.model.UpdateLaunchProfileResponse.ReadOnly
            ] = proxy(UpdateLaunchProfile, request)
            def createLaunchProfile(request: CreateLaunchProfileRequest): IO[
              AwsError,
              zio.aws.nimble.model.CreateLaunchProfileResponse.ReadOnly
            ] = proxy(CreateLaunchProfile, request)
            def acceptEulas(
                request: AcceptEulasRequest
            ): IO[AwsError, zio.aws.nimble.model.AcceptEulasResponse.ReadOnly] =
              proxy(AcceptEulas, request)
            def getEula(
                request: GetEulaRequest
            ): IO[AwsError, zio.aws.nimble.model.GetEulaResponse.ReadOnly] =
              proxy(GetEula, request)
            def getLaunchProfile(request: GetLaunchProfileRequest): IO[
              AwsError,
              zio.aws.nimble.model.GetLaunchProfileResponse.ReadOnly
            ] = proxy(GetLaunchProfile, request)
            def listEulaAcceptances(
                request: ListEulaAcceptancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.nimble.model.EulaAcceptance.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEulaAcceptances, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEulaAcceptancesPaginated(
                request: ListEulaAcceptancesRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.ListEulaAcceptancesResponse.ReadOnly
            ] = proxy(ListEulaAcceptancesPaginated, request)
            def deleteStreamingSession(
                request: DeleteStreamingSessionRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.DeleteStreamingSessionResponse.ReadOnly
            ] = proxy(DeleteStreamingSession, request)
            def deleteLaunchProfile(request: DeleteLaunchProfileRequest): IO[
              AwsError,
              zio.aws.nimble.model.DeleteLaunchProfileResponse.ReadOnly
            ] = proxy(DeleteLaunchProfile, request)
            def getStreamingImage(request: GetStreamingImageRequest): IO[
              AwsError,
              zio.aws.nimble.model.GetStreamingImageResponse.ReadOnly
            ] = proxy(GetStreamingImage, request)
            def updateStudioComponent(
                request: UpdateStudioComponentRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.UpdateStudioComponentResponse.ReadOnly
            ] = proxy(UpdateStudioComponent, request)
            def listStudioComponents(
                request: ListStudioComponentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.nimble.model.StudioComponent.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStudioComponents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStudioComponentsPaginated(
                request: ListStudioComponentsRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly
            ] = proxy(ListStudioComponentsPaginated, request)
            def getStudio(request: GetStudioRequest): IO[AwsError, ReadOnly] =
              proxy(GetStudio, request)
            def listStudioMembers(request: ListStudioMembersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.nimble.model.StudioMembership.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStudioMembers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStudioMembersPaginated(
                request: ListStudioMembersRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.ListStudioMembersResponse.ReadOnly
            ] = proxy(ListStudioMembersPaginated, request)
            def listLaunchProfiles(request: ListLaunchProfilesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.nimble.model.LaunchProfile.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLaunchProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLaunchProfilesPaginated(
                request: ListLaunchProfilesRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.ListLaunchProfilesResponse.ReadOnly
            ] = proxy(ListLaunchProfilesPaginated, request)
            def deleteStudioComponent(
                request: DeleteStudioComponentRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.DeleteStudioComponentResponse.ReadOnly
            ] = proxy(DeleteStudioComponent, request)
            def createStreamingImage(request: CreateStreamingImageRequest): IO[
              AwsError,
              zio.aws.nimble.model.CreateStreamingImageResponse.ReadOnly
            ] = proxy(CreateStreamingImage, request)
            def getStudioMember(request: GetStudioMemberRequest): IO[
              AwsError,
              zio.aws.nimble.model.GetStudioMemberResponse.ReadOnly
            ] = proxy(GetStudioMember, request)
            def updateStreamingImage(request: UpdateStreamingImageRequest): IO[
              AwsError,
              zio.aws.nimble.model.UpdateStreamingImageResponse.ReadOnly
            ] = proxy(UpdateStreamingImage, request)
            def updateStudio(request: UpdateStudioRequest): IO[
              AwsError,
              zio.aws.nimble.model.UpdateStudioResponse.ReadOnly
            ] = proxy(UpdateStudio, request)
            def updateLaunchProfileMember(
                request: UpdateLaunchProfileMemberRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.ReadOnly
            ] = proxy(UpdateLaunchProfileMember, request)
            def getStreamingSessionBackup(
                request: GetStreamingSessionBackupRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.GetStreamingSessionBackupResponse.ReadOnly
            ] = proxy(GetStreamingSessionBackup, request)
            def listStudios(
                request: ListStudiosRequest
            ): ZStream[Any, AwsError, zio.aws.nimble.model.Studio.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListStudios, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listStudiosPaginated(
                request: ListStudiosRequest
            ): IO[AwsError, zio.aws.nimble.model.ListStudiosResponse.ReadOnly] =
              proxy(ListStudiosPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.nimble.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listStreamingSessions(
                request: ListStreamingSessionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.nimble.model.StreamingSession.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStreamingSessions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStreamingSessionsPaginated(
                request: ListStreamingSessionsRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly
            ] = proxy(ListStreamingSessionsPaginated, request)
            def listStreamingImages(
                request: ListStreamingImagesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.nimble.model.StreamingImage.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStreamingImages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStreamingImagesPaginated(
                request: ListStreamingImagesRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.ListStreamingImagesResponse.ReadOnly
            ] = proxy(ListStreamingImagesPaginated, request)
            def putStudioMembers(request: PutStudioMembersRequest): IO[
              AwsError,
              zio.aws.nimble.model.PutStudioMembersResponse.ReadOnly
            ] = proxy(PutStudioMembers, request)
            def listEulas(
                request: ListEulasRequest
            ): ZStream[Any, AwsError, zio.aws.nimble.model.Eula.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListEulas, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listEulasPaginated(
                request: ListEulasRequest
            ): IO[AwsError, zio.aws.nimble.model.ListEulasResponse.ReadOnly] =
              proxy(ListEulasPaginated, request)
            def startStreamingSession(
                request: StartStreamingSessionRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.StartStreamingSessionResponse.ReadOnly
            ] = proxy(StartStreamingSession, request)
            def getStreamingSessionStream(
                request: GetStreamingSessionStreamRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.GetStreamingSessionStreamResponse.ReadOnly
            ] = proxy(GetStreamingSessionStream, request)
            def createStreamingSession(
                request: CreateStreamingSessionRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.CreateStreamingSessionResponse.ReadOnly
            ] = proxy(CreateStreamingSession, request)
            def getStreamingSession(request: GetStreamingSessionRequest): IO[
              AwsError,
              zio.aws.nimble.model.GetStreamingSessionResponse.ReadOnly
            ] = proxy(GetStreamingSession, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.nimble.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def getLaunchProfileInitialization(
                request: GetLaunchProfileInitializationRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.GetLaunchProfileInitializationResponse.ReadOnly
            ] = proxy(GetLaunchProfileInitialization, request)
            def deleteStudio(request: DeleteStudioRequest): IO[
              AwsError,
              zio.aws.nimble.model.DeleteStudioResponse.ReadOnly
            ] = proxy(DeleteStudio, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.nimble.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def putLaunchProfileMembers(
                request: PutLaunchProfileMembersRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.PutLaunchProfileMembersResponse.ReadOnly
            ] = proxy(PutLaunchProfileMembers, request)
            def getStudioComponent(request: GetStudioComponentRequest): IO[
              AwsError,
              zio.aws.nimble.model.GetStudioComponentResponse.ReadOnly
            ] = proxy(GetStudioComponent, request)
            def getLaunchProfileMember(
                request: GetLaunchProfileMemberRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.GetLaunchProfileMemberResponse.ReadOnly
            ] = proxy(GetLaunchProfileMember, request)
            def deleteStudioMember(request: DeleteStudioMemberRequest): IO[
              AwsError,
              zio.aws.nimble.model.DeleteStudioMemberResponse.ReadOnly
            ] = proxy(DeleteStudioMember, request)
            def createStudioComponent(
                request: CreateStudioComponentRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.CreateStudioComponentResponse.ReadOnly
            ] = proxy(CreateStudioComponent, request)
            def createStreamingSessionStream(
                request: CreateStreamingSessionStreamRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.CreateStreamingSessionStreamResponse.ReadOnly
            ] = proxy(CreateStreamingSessionStream, request)
            def startStudioSSOConfigurationRepair(
                request: StartStudioSsoConfigurationRepairRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.StartStudioSsoConfigurationRepairResponse.ReadOnly
            ] = proxy(StartStudioSSOConfigurationRepair, request)
            def deleteLaunchProfileMember(
                request: DeleteLaunchProfileMemberRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.DeleteLaunchProfileMemberResponse.ReadOnly
            ] = proxy(DeleteLaunchProfileMember, request)
            def listStreamingSessionBackups(
                request: ListStreamingSessionBackupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.nimble.model.StreamingSessionBackup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStreamingSessionBackups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStreamingSessionBackupsPaginated(
                request: ListStreamingSessionBackupsRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.ListStreamingSessionBackupsResponse.ReadOnly
            ] = proxy(ListStreamingSessionBackupsPaginated, request)
            def getLaunchProfileDetails(
                request: GetLaunchProfileDetailsRequest
            ): IO[
              AwsError,
              zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly
            ] = proxy(GetLaunchProfileDetails, request)
            def stopStreamingSession(request: StopStreamingSessionRequest): IO[
              AwsError,
              zio.aws.nimble.model.StopStreamingSessionResponse.ReadOnly
            ] = proxy(StopStreamingSession, request)
          }
        }
      }
    }
  }
}
