package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEulaAcceptancesRequest(
    eulaIds: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest = {
    import ListEulaAcceptancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest
      .builder()
      .optionallyWith(
        eulaIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eulaIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListEulaAcceptancesRequest.ReadOnly =
    zio.aws.nimble.model.ListEulaAcceptancesRequest.wrap(buildAwsValue())
}
object ListEulaAcceptancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListEulaAcceptancesRequest =
      zio.aws.nimble.model.ListEulaAcceptancesRequest(
        eulaIds.map(value => value),
        nextToken.map(value => value),
        studioId
      )
    def eulaIds: Optional[List[String]]
    def nextToken: Optional[String]
    def studioId: String
    def getEulaIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eulaIds", eulaIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest
  ) extends zio.aws.nimble.model.ListEulaAcceptancesRequest.ReadOnly {
    override val eulaIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eulaIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest
  ): zio.aws.nimble.model.ListEulaAcceptancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
