package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioComponentName,
  StudioComponentId,
  StudioComponentInitializationScriptContent,
  RoleArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchProfileInitializationScript(
    runtimeRoleArn: Optional[RoleArn] = Optional.Absent,
    script: Optional[StudioComponentInitializationScriptContent] =
      Optional.Absent,
    secureInitializationRoleArn: Optional[RoleArn] = Optional.Absent,
    studioComponentId: Optional[StudioComponentId] = Optional.Absent,
    studioComponentName: Optional[StudioComponentName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript = {
    import LaunchProfileInitializationScript.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript
      .builder()
      .optionallyWith(
        runtimeRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.runtimeRoleArn)
      .optionallyWith(
        script.map(value =>
          StudioComponentInitializationScriptContent.unwrap(
            value
          ): java.lang.String
        )
      )(_.script)
      .optionallyWith(
        secureInitializationRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.secureInitializationRoleArn)
      .optionallyWith(
        studioComponentId.map(value =>
          StudioComponentId.unwrap(value): java.lang.String
        )
      )(_.studioComponentId)
      .optionallyWith(
        studioComponentName.map(value =>
          StudioComponentName.unwrap(value): java.lang.String
        )
      )(_.studioComponentName)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly =
    zio.aws.nimble.model.LaunchProfileInitializationScript.wrap(buildAwsValue())
}
object LaunchProfileInitializationScript {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.LaunchProfileInitializationScript =
      zio.aws.nimble.model.LaunchProfileInitializationScript(
        runtimeRoleArn.map(value => value),
        script.map(value => value),
        secureInitializationRoleArn.map(value => value),
        studioComponentId.map(value => value),
        studioComponentName.map(value => value)
      )
    def runtimeRoleArn: Optional[RoleArn]
    def script: Optional[StudioComponentInitializationScriptContent]
    def secureInitializationRoleArn: Optional[RoleArn]
    def studioComponentId: Optional[StudioComponentId]
    def studioComponentName: Optional[StudioComponentName]
    def getRuntimeRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("runtimeRoleArn", runtimeRoleArn)
    def getScript
        : ZIO[Any, AwsError, StudioComponentInitializationScriptContent] =
      AwsError.unwrapOptionField("script", script)
    def getSecureInitializationRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField(
        "secureInitializationRoleArn",
        secureInitializationRoleArn
      )
    def getStudioComponentId: ZIO[Any, AwsError, StudioComponentId] =
      AwsError.unwrapOptionField("studioComponentId", studioComponentId)
    def getStudioComponentName: ZIO[Any, AwsError, StudioComponentName] =
      AwsError.unwrapOptionField("studioComponentName", studioComponentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript
  ) extends zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly {
    override val runtimeRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeRoleArn())
      .map(value => zio.aws.nimble.model.primitives.RoleArn(value))
    override val script: Optional[StudioComponentInitializationScriptContent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.script())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StudioComponentInitializationScriptContent(value)
        )
    override val secureInitializationRoleArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secureInitializationRoleArn())
        .map(value => zio.aws.nimble.model.primitives.RoleArn(value))
    override val studioComponentId: Optional[StudioComponentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentId())
        .map(value => zio.aws.nimble.model.primitives.StudioComponentId(value))
    override val studioComponentName: Optional[StudioComponentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentName())
        .map(value =>
          zio.aws.nimble.model.primitives.StudioComponentName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript
  ): zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly =
    new Wrapper(impl)
}
