package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLaunchProfileRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    launchProfileId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileRequest = {
    import DeleteLaunchProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .launchProfileId(launchProfileId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteLaunchProfileRequest.ReadOnly =
    zio.aws.nimble.model.DeleteLaunchProfileRequest.wrap(buildAwsValue())
}
object DeleteLaunchProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteLaunchProfileRequest =
      zio.aws.nimble.model.DeleteLaunchProfileRequest(
        clientToken.map(value => value),
        launchProfileId,
        studioId
      )
    def clientToken: Optional[ClientToken]
    def launchProfileId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileRequest
  ) extends zio.aws.nimble.model.DeleteLaunchProfileRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val launchProfileId: String = impl.launchProfileId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileRequest
  ): zio.aws.nimble.model.DeleteLaunchProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
