package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStreamingImageResponse(
    streamingImage: Optional[zio.aws.nimble.model.StreamingImage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateStreamingImageResponse = {
    import UpdateStreamingImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateStreamingImageResponse
      .builder()
      .optionallyWith(streamingImage.map(value => value.buildAwsValue()))(
        _.streamingImage
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateStreamingImageResponse.ReadOnly =
    zio.aws.nimble.model.UpdateStreamingImageResponse.wrap(buildAwsValue())
}
object UpdateStreamingImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateStreamingImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateStreamingImageResponse =
      zio.aws.nimble.model.UpdateStreamingImageResponse(
        streamingImage.map(value => value.asEditable)
      )
    def streamingImage: Optional[zio.aws.nimble.model.StreamingImage.ReadOnly]
    def getStreamingImage
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingImage.ReadOnly] =
      AwsError.unwrapOptionField("streamingImage", streamingImage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStreamingImageResponse
  ) extends zio.aws.nimble.model.UpdateStreamingImageResponse.ReadOnly {
    override val streamingImage
        : Optional[zio.aws.nimble.model.StreamingImage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingImage())
        .map(value => zio.aws.nimble.model.StreamingImage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStreamingImageResponse
  ): zio.aws.nimble.model.UpdateStreamingImageResponse.ReadOnly = new Wrapper(
    impl
  )
}
