package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  SyntheticUpdateStreamingImageRequestStreamingImageName,
  SyntheticUpdateStreamingImageRequestStreamingImageDescription,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStreamingImageRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[
      SyntheticUpdateStreamingImageRequestStreamingImageDescription
    ] = Optional.Absent,
    name: Optional[SyntheticUpdateStreamingImageRequestStreamingImageName] =
      Optional.Absent,
    streamingImageId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest = {
    import UpdateStreamingImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          SyntheticUpdateStreamingImageRequestStreamingImageDescription.unwrap(
            value
          ): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value =>
          SyntheticUpdateStreamingImageRequestStreamingImageName.unwrap(
            value
          ): java.lang.String
        )
      )(_.name)
      .streamingImageId(streamingImageId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateStreamingImageRequest.ReadOnly =
    zio.aws.nimble.model.UpdateStreamingImageRequest.wrap(buildAwsValue())
}
object UpdateStreamingImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateStreamingImageRequest =
      zio.aws.nimble.model.UpdateStreamingImageRequest(
        clientToken.map(value => value),
        description.map(value => value),
        name.map(value => value),
        streamingImageId,
        studioId
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[
      SyntheticUpdateStreamingImageRequestStreamingImageDescription
    ]
    def name: Optional[SyntheticUpdateStreamingImageRequestStreamingImageName]
    def streamingImageId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[
      Any,
      AwsError,
      SyntheticUpdateStreamingImageRequestStreamingImageDescription
    ] = AwsError.unwrapOptionField("description", description)
    def getName: ZIO[
      Any,
      AwsError,
      SyntheticUpdateStreamingImageRequestStreamingImageName
    ] = AwsError.unwrapOptionField("name", name)
    def getStreamingImageId: ZIO[Any, Nothing, String] =
      ZIO.succeed(streamingImageId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest
  ) extends zio.aws.nimble.model.UpdateStreamingImageRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val description: Optional[
      SyntheticUpdateStreamingImageRequestStreamingImageDescription
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.nimble.model.primitives
          .SyntheticUpdateStreamingImageRequestStreamingImageDescription(value)
      )
    override val name
        : Optional[SyntheticUpdateStreamingImageRequestStreamingImageName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.nimble.model.primitives
            .SyntheticUpdateStreamingImageRequestStreamingImageName(value)
        )
    override val streamingImageId: String = impl.streamingImageId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest
  ): zio.aws.nimble.model.UpdateStreamingImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
