package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait StudioEncryptionConfigurationKeyType {
  def unwrap: software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType
}
object StudioEncryptionConfigurationKeyType {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType
  ): zio.aws.nimble.model.StudioEncryptionConfigurationKeyType = value match {
    case software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType.AWS_OWNED_KEY =>
      val r = AWS_OWNED_KEY
      r
    case software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType.CUSTOMER_MANAGED_KEY =>
      val r = CUSTOMER_MANAGED_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StudioEncryptionConfigurationKeyType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType =
      software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_OWNED_KEY
      extends zio.aws.nimble.model.StudioEncryptionConfigurationKeyType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType =
      software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType.AWS_OWNED_KEY
  }
  case object CUSTOMER_MANAGED_KEY
      extends zio.aws.nimble.model.StudioEncryptionConfigurationKeyType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType =
      software.amazon.awssdk.services.nimble.model.StudioEncryptionConfigurationKeyType.CUSTOMER_MANAGED_KEY
  }
}
