package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.StudioEncryptionConfigurationKeyArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StudioEncryptionConfiguration(
    keyArn: Optional[StudioEncryptionConfigurationKeyArn] = Optional.Absent,
    keyType: zio.aws.nimble.model.StudioEncryptionConfigurationKeyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StudioEncryptionConfiguration = {
    import StudioEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StudioEncryptionConfiguration
      .builder()
      .optionallyWith(
        keyArn.map(value =>
          StudioEncryptionConfigurationKeyArn.unwrap(value): java.lang.String
        )
      )(_.keyArn)
      .keyType(keyType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly =
    zio.aws.nimble.model.StudioEncryptionConfiguration.wrap(buildAwsValue())
}
object StudioEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StudioEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StudioEncryptionConfiguration =
      zio.aws.nimble.model
        .StudioEncryptionConfiguration(keyArn.map(value => value), keyType)
    def keyArn: Optional[StudioEncryptionConfigurationKeyArn]
    def keyType: zio.aws.nimble.model.StudioEncryptionConfigurationKeyType
    def getKeyArn: ZIO[Any, AwsError, StudioEncryptionConfigurationKeyArn] =
      AwsError.unwrapOptionField("keyArn", keyArn)
    def getKeyType: ZIO[
      Any,
      Nothing,
      zio.aws.nimble.model.StudioEncryptionConfigurationKeyType
    ] = ZIO.succeed(keyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StudioEncryptionConfiguration
  ) extends zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly {
    override val keyArn: Optional[StudioEncryptionConfigurationKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyArn())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StudioEncryptionConfigurationKeyArn(value)
        )
    override val keyType
        : zio.aws.nimble.model.StudioEncryptionConfigurationKeyType =
      zio.aws.nimble.model.StudioEncryptionConfigurationKeyType
        .wrap(impl.keyType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StudioEncryptionConfiguration
  ): zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
