package zio.aws.nimble.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{
  StudioComponentId,
  StudioComponentName,
  StudioComponentDescription,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class StudioComponentSummary(
    createdAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[String] = Optional.Absent,
    description: Optional[StudioComponentDescription] = Optional.Absent,
    name: Optional[StudioComponentName] = Optional.Absent,
    studioComponentId: Optional[StudioComponentId] = Optional.Absent,
    subtype: Optional[zio.aws.nimble.model.StudioComponentSubtype] =
      Optional.Absent,
    `type`: Optional[zio.aws.nimble.model.StudioComponentType] =
      Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    updatedBy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StudioComponentSummary = {
    import StudioComponentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StudioComponentSummary
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        description.map(value =>
          StudioComponentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value => StudioComponentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        studioComponentId.map(value =>
          StudioComponentId.unwrap(value): java.lang.String
        )
      )(_.studioComponentId)
      .optionallyWith(subtype.map(value => value.unwrap))(_.subtype)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(updatedBy.map(value => value: java.lang.String))(
        _.updatedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StudioComponentSummary.ReadOnly =
    zio.aws.nimble.model.StudioComponentSummary.wrap(buildAwsValue())
}
object StudioComponentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StudioComponentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StudioComponentSummary =
      zio.aws.nimble.model.StudioComponentSummary(
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        name.map(value => value),
        studioComponentId.map(value => value),
        subtype.map(value => value),
        `type`.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def createdAt: Optional[Timestamp]
    def createdBy: Optional[String]
    def description: Optional[StudioComponentDescription]
    def name: Optional[StudioComponentName]
    def studioComponentId: Optional[StudioComponentId]
    def subtype: Optional[zio.aws.nimble.model.StudioComponentSubtype]
    def `type`: Optional[zio.aws.nimble.model.StudioComponentType]
    def updatedAt: Optional[Timestamp]
    def updatedBy: Optional[String]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, StudioComponentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, StudioComponentName] =
      AwsError.unwrapOptionField("name", name)
    def getStudioComponentId: ZIO[Any, AwsError, StudioComponentId] =
      AwsError.unwrapOptionField("studioComponentId", studioComponentId)
    def getSubtype
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentSubtype] =
      AwsError.unwrapOptionField("subtype", subtype)
    def getType: ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentSummary
  ) extends zio.aws.nimble.model.StudioComponentSummary.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val description: Optional[StudioComponentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.nimble.model.primitives.StudioComponentDescription(value)
        )
    override val name: Optional[StudioComponentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.nimble.model.primitives.StudioComponentName(value))
    override val studioComponentId: Optional[StudioComponentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentId())
        .map(value => zio.aws.nimble.model.primitives.StudioComponentId(value))
    override val subtype
        : Optional[zio.aws.nimble.model.StudioComponentSubtype] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subtype())
        .map(value => zio.aws.nimble.model.StudioComponentSubtype.wrap(value))
    override val `type`: Optional[zio.aws.nimble.model.StudioComponentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.nimble.model.StudioComponentType.wrap(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentSummary
  ): zio.aws.nimble.model.StudioComponentSummary.ReadOnly = new Wrapper(impl)
}
