package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait StudioComponentStatusCode {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode
}
object StudioComponentStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode
  ): zio.aws.nimble.model.StudioComponentStatusCode = value match {
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.ACTIVE_DIRECTORY_ALREADY_EXISTS =>
      val r = ACTIVE_DIRECTORY_ALREADY_EXISTS
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_CREATED =>
      val r = STUDIO_COMPONENT_CREATED
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_UPDATED =>
      val r = STUDIO_COMPONENT_UPDATED
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_DELETED =>
      val r = STUDIO_COMPONENT_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.ENCRYPTION_KEY_ACCESS_DENIED =>
      val r = ENCRYPTION_KEY_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.ENCRYPTION_KEY_NOT_FOUND =>
      val r = ENCRYPTION_KEY_NOT_FOUND
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_CREATE_IN_PROGRESS =>
      val r = STUDIO_COMPONENT_CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_UPDATE_IN_PROGRESS =>
      val r = STUDIO_COMPONENT_UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_DELETE_IN_PROGRESS =>
      val r = STUDIO_COMPONENT_DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE_DIRECTORY_ALREADY_EXISTS
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.ACTIVE_DIRECTORY_ALREADY_EXISTS
  }
  case object STUDIO_COMPONENT_CREATED
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_CREATED
  }
  case object STUDIO_COMPONENT_UPDATED
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_UPDATED
  }
  case object STUDIO_COMPONENT_DELETED
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_DELETED
  }
  case object ENCRYPTION_KEY_ACCESS_DENIED
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.ENCRYPTION_KEY_ACCESS_DENIED
  }
  case object ENCRYPTION_KEY_NOT_FOUND
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.ENCRYPTION_KEY_NOT_FOUND
  }
  case object STUDIO_COMPONENT_CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_CREATE_IN_PROGRESS
  }
  case object STUDIO_COMPONENT_UPDATE_IN_PROGRESS
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_UPDATE_IN_PROGRESS
  }
  case object STUDIO_COMPONENT_DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.STUDIO_COMPONENT_DELETE_IN_PROGRESS
  }
  case object INTERNAL_ERROR
      extends zio.aws.nimble.model.StudioComponentStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode =
      software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode.INTERNAL_ERROR
  }
}
