package zio.aws.nimble.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{
  StudioName,
  Region,
  SyntheticStudioStudioDisplayName,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class Studio(
    adminRoleArn: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    displayName: Optional[SyntheticStudioStudioDisplayName] = Optional.Absent,
    homeRegion: Optional[Region] = Optional.Absent,
    ssoClientId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.nimble.model.StudioState] = Optional.Absent,
    statusCode: Optional[zio.aws.nimble.model.StudioStatusCode] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    studioEncryptionConfiguration: Optional[
      zio.aws.nimble.model.StudioEncryptionConfiguration
    ] = Optional.Absent,
    studioId: Optional[String] = Optional.Absent,
    studioName: Optional[StudioName] = Optional.Absent,
    studioUrl: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    userRoleArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.nimble.model.Studio = {
    import Studio.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.Studio
      .builder()
      .optionallyWith(adminRoleArn.map(value => value: java.lang.String))(
        _.adminRoleArn
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        displayName.map(value =>
          SyntheticStudioStudioDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        homeRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.homeRegion)
      .optionallyWith(ssoClientId.map(value => value: java.lang.String))(
        _.ssoClientId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        studioEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.studioEncryptionConfiguration)
      .optionallyWith(studioId.map(value => value: java.lang.String))(
        _.studioId
      )
      .optionallyWith(
        studioName.map(value => StudioName.unwrap(value): java.lang.String)
      )(_.studioName)
      .optionallyWith(studioUrl.map(value => value: java.lang.String))(
        _.studioUrl
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(userRoleArn.map(value => value: java.lang.String))(
        _.userRoleArn
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.Studio.ReadOnly =
    zio.aws.nimble.model.Studio.wrap(buildAwsValue())
}
object Studio {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.nimble.model.Studio] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.Studio = zio.aws.nimble.model.Studio(
      adminRoleArn.map(value => value),
      arn.map(value => value),
      createdAt.map(value => value),
      displayName.map(value => value),
      homeRegion.map(value => value),
      ssoClientId.map(value => value),
      state.map(value => value),
      statusCode.map(value => value),
      statusMessage.map(value => value),
      studioEncryptionConfiguration.map(value => value.asEditable),
      studioId.map(value => value),
      studioName.map(value => value),
      studioUrl.map(value => value),
      tags.map(value => value),
      updatedAt.map(value => value),
      userRoleArn.map(value => value)
    )
    def adminRoleArn: Optional[String]
    def arn: Optional[String]
    def createdAt: Optional[Timestamp]
    def displayName: Optional[SyntheticStudioStudioDisplayName]
    def homeRegion: Optional[Region]
    def ssoClientId: Optional[String]
    def state: Optional[zio.aws.nimble.model.StudioState]
    def statusCode: Optional[zio.aws.nimble.model.StudioStatusCode]
    def statusMessage: Optional[String]
    def studioEncryptionConfiguration
        : Optional[zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly]
    def studioId: Optional[String]
    def studioName: Optional[StudioName]
    def studioUrl: Optional[String]
    def tags: Optional[Map[String, String]]
    def updatedAt: Optional[Timestamp]
    def userRoleArn: Optional[String]
    def getAdminRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("adminRoleArn", adminRoleArn)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDisplayName: ZIO[Any, AwsError, SyntheticStudioStudioDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getHomeRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("homeRegion", homeRegion)
    def getSsoClientId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ssoClientId", ssoClientId)
    def getState: ZIO[Any, AwsError, zio.aws.nimble.model.StudioState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStudioEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "studioEncryptionConfiguration",
      studioEncryptionConfiguration
    )
    def getStudioId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getStudioName: ZIO[Any, AwsError, StudioName] =
      AwsError.unwrapOptionField("studioName", studioName)
    def getStudioUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("studioUrl", studioUrl)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUserRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userRoleArn", userRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.Studio
  ) extends zio.aws.nimble.model.Studio.ReadOnly {
    override val adminRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.adminRoleArn())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val displayName: Optional[SyntheticStudioStudioDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.nimble.model.primitives
            .SyntheticStudioStudioDisplayName(value)
        )
    override val homeRegion: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.homeRegion())
      .map(value => zio.aws.nimble.model.primitives.Region(value))
    override val ssoClientId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ssoClientId())
      .map(value => value: String)
    override val state: Optional[zio.aws.nimble.model.StudioState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.nimble.model.StudioState.wrap(value))
    override val statusCode: Optional[zio.aws.nimble.model.StudioStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value => zio.aws.nimble.model.StudioStatusCode.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val studioEncryptionConfiguration: Optional[
      zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.studioEncryptionConfiguration())
      .map(value =>
        zio.aws.nimble.model.StudioEncryptionConfiguration.wrap(value)
      )
    override val studioId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.studioId())
      .map(value => value: String)
    override val studioName: Optional[StudioName] = zio.aws.core.internal
      .optionalFromNullable(impl.studioName())
      .map(value => zio.aws.nimble.model.primitives.StudioName(value))
    override val studioUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.studioUrl())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val userRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userRoleArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.Studio
  ): zio.aws.nimble.model.Studio.ReadOnly = new Wrapper(impl)
}
