package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait StreamingSessionStreamState {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState
}
object StreamingSessionStreamState {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState
  ): zio.aws.nimble.model.StreamingSessionStreamState = value match {
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingSessionStreamState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.UNKNOWN_TO_SDK_VERSION
  }
  case object READY extends zio.aws.nimble.model.StreamingSessionStreamState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.READY
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionStreamState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.CREATE_IN_PROGRESS
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionStreamState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.DELETE_IN_PROGRESS
  }
  case object DELETED extends zio.aws.nimble.model.StreamingSessionStreamState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.DELETED
  }
  case object CREATE_FAILED
      extends zio.aws.nimble.model.StreamingSessionStreamState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.CREATE_FAILED
  }
  case object DELETE_FAILED
      extends zio.aws.nimble.model.StreamingSessionStreamState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamState.DELETE_FAILED
  }
}
