package zio.aws.nimble.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{
  SyntheticStreamingSessionStreamString,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class StreamingSessionStream(
    createdAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[String] = Optional.Absent,
    expiresAt: Optional[Timestamp] = Optional.Absent,
    ownedBy: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.nimble.model.StreamingSessionStreamState] =
      Optional.Absent,
    statusCode: Optional[
      zio.aws.nimble.model.StreamingSessionStreamStatusCode
    ] = Optional.Absent,
    streamId: Optional[String] = Optional.Absent,
    url: Optional[SyntheticStreamingSessionStreamString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamingSessionStream = {
    import StreamingSessionStream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamingSessionStream
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(expiresAt.map(value => Timestamp.unwrap(value): Instant))(
        _.expiresAt
      )
      .optionallyWith(ownedBy.map(value => value: java.lang.String))(_.ownedBy)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(streamId.map(value => value: java.lang.String))(
        _.streamId
      )
      .optionallyWith(
        url.map(value =>
          SyntheticStreamingSessionStreamString.unwrap(value): java.lang.String
        )
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamingSessionStream.ReadOnly =
    zio.aws.nimble.model.StreamingSessionStream.wrap(buildAwsValue())
}
object StreamingSessionStream {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamingSessionStream
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamingSessionStream =
      zio.aws.nimble.model.StreamingSessionStream(
        createdAt.map(value => value),
        createdBy.map(value => value),
        expiresAt.map(value => value),
        ownedBy.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        streamId.map(value => value),
        url.map(value => value)
      )
    def createdAt: Optional[Timestamp]
    def createdBy: Optional[String]
    def expiresAt: Optional[Timestamp]
    def ownedBy: Optional[String]
    def state: Optional[zio.aws.nimble.model.StreamingSessionStreamState]
    def statusCode
        : Optional[zio.aws.nimble.model.StreamingSessionStreamStatusCode]
    def streamId: Optional[String]
    def url: Optional[SyntheticStreamingSessionStreamString]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getExpiresAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiresAt", expiresAt)
    def getOwnedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getState
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSessionStreamState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamingSessionStreamStatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
    def getStreamId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getUrl: ZIO[Any, AwsError, SyntheticStreamingSessionStreamString] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSessionStream
  ) extends zio.aws.nimble.model.StreamingSessionStream.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val expiresAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val ownedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownedBy())
      .map(value => value: String)
    override val state
        : Optional[zio.aws.nimble.model.StreamingSessionStreamState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.nimble.model.StreamingSessionStreamState.wrap(value)
        )
    override val statusCode
        : Optional[zio.aws.nimble.model.StreamingSessionStreamStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.nimble.model.StreamingSessionStreamStatusCode.wrap(value)
        )
    override val streamId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => value: String)
    override val url: Optional[SyntheticStreamingSessionStreamString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.url())
        .map(value =>
          zio.aws.nimble.model.primitives
            .SyntheticStreamingSessionStreamString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSessionStream
  ): zio.aws.nimble.model.StreamingSessionStream.ReadOnly = new Wrapper(impl)
}
