package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait StreamingSessionStorageMode {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.StreamingSessionStorageMode
}
object StreamingSessionStorageMode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingSessionStorageMode
  ): zio.aws.nimble.model.StreamingSessionStorageMode = value match {
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStorageMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStorageMode.UPLOAD =>
      val r = UPLOAD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingSessionStorageMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStorageMode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStorageMode.UNKNOWN_TO_SDK_VERSION
  }
  case object UPLOAD extends zio.aws.nimble.model.StreamingSessionStorageMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStorageMode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStorageMode.UPLOAD
  }
}
