package zio.aws.nimble.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{
  StreamingImageId,
  StreamConfigurationMaxStoppedSessionLengthInMinutes,
  StreamConfigurationMaxSessionLengthInMinutes
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StreamConfigurationCreate(
    clipboardMode: zio.aws.nimble.model.StreamingClipboardMode,
    ec2InstanceTypes: Iterable[zio.aws.nimble.model.StreamingInstanceType],
    maxSessionLengthInMinutes: Optional[
      StreamConfigurationMaxSessionLengthInMinutes
    ] = Optional.Absent,
    maxStoppedSessionLengthInMinutes: Optional[
      StreamConfigurationMaxStoppedSessionLengthInMinutes
    ] = Optional.Absent,
    sessionStorage: Optional[
      zio.aws.nimble.model.StreamConfigurationSessionStorage
    ] = Optional.Absent,
    streamingImageIds: Iterable[StreamingImageId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamConfigurationCreate = {
    import StreamConfigurationCreate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamConfigurationCreate
      .builder()
      .clipboardMode(clipboardMode.unwrap)
      .ec2InstanceTypesWithStrings(ec2InstanceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        maxSessionLengthInMinutes.map(value =>
          StreamConfigurationMaxSessionLengthInMinutes.unwrap(value): Integer
        )
      )(_.maxSessionLengthInMinutes)
      .optionallyWith(
        maxStoppedSessionLengthInMinutes.map(value =>
          StreamConfigurationMaxStoppedSessionLengthInMinutes.unwrap(
            value
          ): Integer
        )
      )(_.maxStoppedSessionLengthInMinutes)
      .optionallyWith(sessionStorage.map(value => value.buildAwsValue()))(
        _.sessionStorage
      )
      .streamingImageIds(streamingImageIds.map { item =>
        StreamingImageId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamConfigurationCreate.ReadOnly =
    zio.aws.nimble.model.StreamConfigurationCreate.wrap(buildAwsValue())
}
object StreamConfigurationCreate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamConfigurationCreate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamConfigurationCreate =
      zio.aws.nimble.model.StreamConfigurationCreate(
        clipboardMode,
        ec2InstanceTypes,
        maxSessionLengthInMinutes.map(value => value),
        maxStoppedSessionLengthInMinutes.map(value => value),
        sessionStorage.map(value => value.asEditable),
        streamingImageIds
      )
    def clipboardMode: zio.aws.nimble.model.StreamingClipboardMode
    def ec2InstanceTypes: List[zio.aws.nimble.model.StreamingInstanceType]
    def maxSessionLengthInMinutes
        : Optional[StreamConfigurationMaxSessionLengthInMinutes]
    def maxStoppedSessionLengthInMinutes
        : Optional[StreamConfigurationMaxStoppedSessionLengthInMinutes]
    def sessionStorage: Optional[
      zio.aws.nimble.model.StreamConfigurationSessionStorage.ReadOnly
    ]
    def streamingImageIds: List[StreamingImageId]
    def getClipboardMode
        : ZIO[Any, Nothing, zio.aws.nimble.model.StreamingClipboardMode] =
      ZIO.succeed(clipboardMode)
    def getEc2InstanceTypes
        : ZIO[Any, Nothing, List[zio.aws.nimble.model.StreamingInstanceType]] =
      ZIO.succeed(ec2InstanceTypes)
    def getMaxSessionLengthInMinutes
        : ZIO[Any, AwsError, StreamConfigurationMaxSessionLengthInMinutes] =
      AwsError.unwrapOptionField(
        "maxSessionLengthInMinutes",
        maxSessionLengthInMinutes
      )
    def getMaxStoppedSessionLengthInMinutes: ZIO[
      Any,
      AwsError,
      StreamConfigurationMaxStoppedSessionLengthInMinutes
    ] = AwsError.unwrapOptionField(
      "maxStoppedSessionLengthInMinutes",
      maxStoppedSessionLengthInMinutes
    )
    def getSessionStorage: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamConfigurationSessionStorage.ReadOnly
    ] = AwsError.unwrapOptionField("sessionStorage", sessionStorage)
    def getStreamingImageIds: ZIO[Any, Nothing, List[StreamingImageId]] =
      ZIO.succeed(streamingImageIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamConfigurationCreate
  ) extends zio.aws.nimble.model.StreamConfigurationCreate.ReadOnly {
    override val clipboardMode: zio.aws.nimble.model.StreamingClipboardMode =
      zio.aws.nimble.model.StreamingClipboardMode.wrap(impl.clipboardMode())
    override val ec2InstanceTypes
        : List[zio.aws.nimble.model.StreamingInstanceType] = impl
      .ec2InstanceTypes()
      .asScala
      .map { item =>
        zio.aws.nimble.model.StreamingInstanceType.wrap(item)
      }
      .toList
    override val maxSessionLengthInMinutes
        : Optional[StreamConfigurationMaxSessionLengthInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSessionLengthInMinutes())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StreamConfigurationMaxSessionLengthInMinutes(value)
        )
    override val maxStoppedSessionLengthInMinutes
        : Optional[StreamConfigurationMaxStoppedSessionLengthInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxStoppedSessionLengthInMinutes())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StreamConfigurationMaxStoppedSessionLengthInMinutes(value)
        )
    override val sessionStorage: Optional[
      zio.aws.nimble.model.StreamConfigurationSessionStorage.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionStorage())
      .map(value =>
        zio.aws.nimble.model.StreamConfigurationSessionStorage.wrap(value)
      )
    override val streamingImageIds: List[StreamingImageId] = impl
      .streamingImageIds()
      .asScala
      .map { item =>
        zio.aws.nimble.model.primitives.StreamingImageId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamConfigurationCreate
  ): zio.aws.nimble.model.StreamConfigurationCreate.ReadOnly = new Wrapper(impl)
}
