package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  ScriptParameterValue,
  ScriptParameterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScriptParameterKeyValue(
    key: Optional[ScriptParameterKey] = Optional.Absent,
    value: Optional[ScriptParameterValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ScriptParameterKeyValue = {
    import ScriptParameterKeyValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ScriptParameterKeyValue
      .builder()
      .optionallyWith(
        key.map(value => ScriptParameterKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => ScriptParameterValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly =
    zio.aws.nimble.model.ScriptParameterKeyValue.wrap(buildAwsValue())
}
object ScriptParameterKeyValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ScriptParameterKeyValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ScriptParameterKeyValue =
      zio.aws.nimble.model.ScriptParameterKeyValue(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Optional[ScriptParameterKey]
    def value: Optional[ScriptParameterValue]
    def getKey: ZIO[Any, AwsError, ScriptParameterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, ScriptParameterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ScriptParameterKeyValue
  ) extends zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly {
    override val key: Optional[ScriptParameterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.nimble.model.primitives.ScriptParameterKey(value))
    override val value: Optional[ScriptParameterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.nimble.model.primitives.ScriptParameterValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ScriptParameterKeyValue
  ): zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly = new Wrapper(impl)
}
