package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamingSessionsResponse(
    nextToken: Optional[String] = Optional.Absent,
    sessions: Optional[Iterable[zio.aws.nimble.model.StreamingSession]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse = {
    import ListStreamingSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        sessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sessions)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly =
    zio.aws.nimble.model.ListStreamingSessionsResponse.wrap(buildAwsValue())
}
object ListStreamingSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStreamingSessionsResponse =
      zio.aws.nimble.model.ListStreamingSessionsResponse(
        nextToken.map(value => value),
        sessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def sessions: Optional[List[zio.aws.nimble.model.StreamingSession.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSessions: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StreamingSession.ReadOnly
    ]] = AwsError.unwrapOptionField("sessions", sessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse
  ) extends zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val sessions
        : Optional[List[zio.aws.nimble.model.StreamingSession.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StreamingSession.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse
  ): zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
