package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamingSessionsRequest(
    createdBy: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    ownedBy: Optional[String] = Optional.Absent,
    sessionIds: Optional[String] = Optional.Absent,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest = {
    import ListStreamingSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest
      .builder()
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(ownedBy.map(value => value: java.lang.String))(_.ownedBy)
      .optionallyWith(sessionIds.map(value => value: java.lang.String))(
        _.sessionIds
      )
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStreamingSessionsRequest.ReadOnly =
    zio.aws.nimble.model.ListStreamingSessionsRequest.wrap(buildAwsValue())
}
object ListStreamingSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStreamingSessionsRequest =
      zio.aws.nimble.model.ListStreamingSessionsRequest(
        createdBy.map(value => value),
        nextToken.map(value => value),
        ownedBy.map(value => value),
        sessionIds.map(value => value),
        studioId
      )
    def createdBy: Optional[String]
    def nextToken: Optional[String]
    def ownedBy: Optional[String]
    def sessionIds: Optional[String]
    def studioId: String
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwnedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getSessionIds: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionIds", sessionIds)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest
  ) extends zio.aws.nimble.model.ListStreamingSessionsRequest.ReadOnly {
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val ownedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownedBy())
      .map(value => value: String)
    override val sessionIds: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionIds())
      .map(value => value: String)
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest
  ): zio.aws.nimble.model.ListStreamingSessionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
