package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamingImagesResponse(
    nextToken: Optional[String] = Optional.Absent,
    streamingImages: Optional[Iterable[zio.aws.nimble.model.StreamingImage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse = {
    import ListStreamingImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        streamingImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamingImages)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStreamingImagesResponse.ReadOnly =
    zio.aws.nimble.model.ListStreamingImagesResponse.wrap(buildAwsValue())
}
object ListStreamingImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStreamingImagesResponse =
      zio.aws.nimble.model.ListStreamingImagesResponse(
        nextToken.map(value => value),
        streamingImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def streamingImages
        : Optional[List[zio.aws.nimble.model.StreamingImage.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStreamingImages: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StreamingImage.ReadOnly
    ]] = AwsError.unwrapOptionField("streamingImages", streamingImages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse
  ) extends zio.aws.nimble.model.ListStreamingImagesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val streamingImages
        : Optional[List[zio.aws.nimble.model.StreamingImage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingImages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StreamingImage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse
  ): zio.aws.nimble.model.ListStreamingImagesResponse.ReadOnly = new Wrapper(
    impl
  )
}
