package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEulasResponse(
    eulas: Optional[Iterable[zio.aws.nimble.model.Eula]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListEulasResponse = {
    import ListEulasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListEulasResponse
      .builder()
      .optionallyWith(
        eulas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eulas)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListEulasResponse.ReadOnly =
    zio.aws.nimble.model.ListEulasResponse.wrap(buildAwsValue())
}
object ListEulasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListEulasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListEulasResponse =
      zio.aws.nimble.model.ListEulasResponse(
        eulas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eulas: Optional[List[zio.aws.nimble.model.Eula.ReadOnly]]
    def nextToken: Optional[String]
    def getEulas: ZIO[Any, AwsError, List[zio.aws.nimble.model.Eula.ReadOnly]] =
      AwsError.unwrapOptionField("eulas", eulas)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListEulasResponse
  ) extends zio.aws.nimble.model.ListEulasResponse.ReadOnly {
    override val eulas: Optional[List[zio.aws.nimble.model.Eula.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eulas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.Eula.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListEulasResponse
  ): zio.aws.nimble.model.ListEulasResponse.ReadOnly = new Wrapper(impl)
}
