package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioComponentName,
  StudioComponentId,
  StudioComponentInitializationScriptContent
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchProfileInitializationScript(
    script: Optional[StudioComponentInitializationScriptContent] =
      Optional.Absent,
    studioComponentId: Optional[StudioComponentId] = Optional.Absent,
    studioComponentName: Optional[StudioComponentName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript = {
    import LaunchProfileInitializationScript.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript
      .builder()
      .optionallyWith(
        script.map(value =>
          StudioComponentInitializationScriptContent.unwrap(
            value
          ): java.lang.String
        )
      )(_.script)
      .optionallyWith(
        studioComponentId.map(value =>
          StudioComponentId.unwrap(value): java.lang.String
        )
      )(_.studioComponentId)
      .optionallyWith(
        studioComponentName.map(value =>
          StudioComponentName.unwrap(value): java.lang.String
        )
      )(_.studioComponentName)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly =
    zio.aws.nimble.model.LaunchProfileInitializationScript.wrap(buildAwsValue())
}
object LaunchProfileInitializationScript {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.LaunchProfileInitializationScript =
      zio.aws.nimble.model.LaunchProfileInitializationScript(
        script.map(value => value),
        studioComponentId.map(value => value),
        studioComponentName.map(value => value)
      )
    def script: Optional[StudioComponentInitializationScriptContent]
    def studioComponentId: Optional[StudioComponentId]
    def studioComponentName: Optional[StudioComponentName]
    def getScript
        : ZIO[Any, AwsError, StudioComponentInitializationScriptContent] =
      AwsError.unwrapOptionField("script", script)
    def getStudioComponentId: ZIO[Any, AwsError, StudioComponentId] =
      AwsError.unwrapOptionField("studioComponentId", studioComponentId)
    def getStudioComponentName: ZIO[Any, AwsError, StudioComponentName] =
      AwsError.unwrapOptionField("studioComponentName", studioComponentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript
  ) extends zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly {
    override val script: Optional[StudioComponentInitializationScriptContent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.script())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StudioComponentInitializationScriptContent(value)
        )
    override val studioComponentId: Optional[StudioComponentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentId())
        .map(value => zio.aws.nimble.model.primitives.StudioComponentId(value))
    override val studioComponentName: Optional[StudioComponentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentName())
        .map(value =>
          zio.aws.nimble.model.primitives.StudioComponentName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationScript
  ): zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly =
    new Wrapper(impl)
}
