package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioComponentName,
  ActiveDirectoryOrganizationalUnitDistinguishedName,
  StudioComponentId,
  ActiveDirectoryDnsIpAddress,
  DirectoryId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchProfileInitializationActiveDirectory(
    computerAttributes: Optional[
      Iterable[zio.aws.nimble.model.ActiveDirectoryComputerAttribute]
    ] = Optional.Absent,
    directoryId: Optional[DirectoryId] = Optional.Absent,
    directoryName: Optional[String] = Optional.Absent,
    dnsIpAddresses: Optional[Iterable[ActiveDirectoryDnsIpAddress]] =
      Optional.Absent,
    organizationalUnitDistinguishedName: Optional[
      ActiveDirectoryOrganizationalUnitDistinguishedName
    ] = Optional.Absent,
    studioComponentId: Optional[StudioComponentId] = Optional.Absent,
    studioComponentName: Optional[StudioComponentName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory = {
    import LaunchProfileInitializationActiveDirectory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory
      .builder()
      .optionallyWith(
        computerAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computerAttributes)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(directoryName.map(value => value: java.lang.String))(
        _.directoryName
      )
      .optionallyWith(
        dnsIpAddresses.map(value =>
          value.map { item =>
            ActiveDirectoryDnsIpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIpAddresses)
      .optionallyWith(
        organizationalUnitDistinguishedName.map(value =>
          ActiveDirectoryOrganizationalUnitDistinguishedName.unwrap(
            value
          ): java.lang.String
        )
      )(_.organizationalUnitDistinguishedName)
      .optionallyWith(
        studioComponentId.map(value =>
          StudioComponentId.unwrap(value): java.lang.String
        )
      )(_.studioComponentId)
      .optionallyWith(
        studioComponentName.map(value =>
          StudioComponentName.unwrap(value): java.lang.String
        )
      )(_.studioComponentName)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly =
    zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory
      .wrap(buildAwsValue())
}
object LaunchProfileInitializationActiveDirectory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory =
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory(
        computerAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        directoryId.map(value => value),
        directoryName.map(value => value),
        dnsIpAddresses.map(value => value),
        organizationalUnitDistinguishedName.map(value => value),
        studioComponentId.map(value => value),
        studioComponentName.map(value => value)
      )
    def computerAttributes: Optional[
      List[zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly]
    ]
    def directoryId: Optional[DirectoryId]
    def directoryName: Optional[String]
    def dnsIpAddresses: Optional[List[ActiveDirectoryDnsIpAddress]]
    def organizationalUnitDistinguishedName
        : Optional[ActiveDirectoryOrganizationalUnitDistinguishedName]
    def studioComponentId: Optional[StudioComponentId]
    def studioComponentName: Optional[StudioComponentName]
    def getComputerAttributes: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("computerAttributes", computerAttributes)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getDirectoryName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("directoryName", directoryName)
    def getDnsIpAddresses
        : ZIO[Any, AwsError, List[ActiveDirectoryDnsIpAddress]] =
      AwsError.unwrapOptionField("dnsIpAddresses", dnsIpAddresses)
    def getOrganizationalUnitDistinguishedName: ZIO[
      Any,
      AwsError,
      ActiveDirectoryOrganizationalUnitDistinguishedName
    ] = AwsError.unwrapOptionField(
      "organizationalUnitDistinguishedName",
      organizationalUnitDistinguishedName
    )
    def getStudioComponentId: ZIO[Any, AwsError, StudioComponentId] =
      AwsError.unwrapOptionField("studioComponentId", studioComponentId)
    def getStudioComponentName: ZIO[Any, AwsError, StudioComponentName] =
      AwsError.unwrapOptionField("studioComponentName", studioComponentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory
  ) extends zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly {
    override val computerAttributes: Optional[
      List[zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.computerAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.ActiveDirectoryComputerAttribute.wrap(item)
        }.toList
      )
    override val directoryId: Optional[DirectoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => zio.aws.nimble.model.primitives.DirectoryId(value))
    override val directoryName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryName())
      .map(value => value: String)
    override val dnsIpAddresses: Optional[List[ActiveDirectoryDnsIpAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.primitives.ActiveDirectoryDnsIpAddress(item)
          }.toList
        )
    override val organizationalUnitDistinguishedName
        : Optional[ActiveDirectoryOrganizationalUnitDistinguishedName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitDistinguishedName())
        .map(value =>
          zio.aws.nimble.model.primitives
            .ActiveDirectoryOrganizationalUnitDistinguishedName(value)
        )
    override val studioComponentId: Optional[StudioComponentId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentId())
        .map(value => zio.aws.nimble.model.primitives.StudioComponentId(value))
    override val studioComponentName: Optional[StudioComponentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentName())
        .map(value =>
          zio.aws.nimble.model.primitives.StudioComponentName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory
  ): zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly =
    new Wrapper(impl)
}
