package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStudioResponse(studio: zio.aws.nimble.model.Studio) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStudioResponse = {
    import GetStudioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStudioResponse
      .builder()
      .studio(studio.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStudioResponse.ReadOnly =
    zio.aws.nimble.model.GetStudioResponse.wrap(buildAwsValue())
}
object GetStudioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStudioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStudioResponse =
      zio.aws.nimble.model.GetStudioResponse(studio.asEditable)
    def studio: zio.aws.nimble.model.Studio.ReadOnly
    def getStudio: ZIO[Any, Nothing, zio.aws.nimble.model.Studio.ReadOnly] =
      ZIO.succeed(studio)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioResponse
  ) extends zio.aws.nimble.model.GetStudioResponse.ReadOnly {
    override val studio: zio.aws.nimble.model.Studio.ReadOnly =
      zio.aws.nimble.model.Studio.wrap(impl.studio())
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioResponse
  ): zio.aws.nimble.model.GetStudioResponse.ReadOnly = new Wrapper(impl)
}
