package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLaunchProfileMemberResponse(
    member: Optional[zio.aws.nimble.model.LaunchProfileMembership] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberResponse = {
    import GetLaunchProfileMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberResponse
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetLaunchProfileMemberResponse.ReadOnly =
    zio.aws.nimble.model.GetLaunchProfileMemberResponse.wrap(buildAwsValue())
}
object GetLaunchProfileMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetLaunchProfileMemberResponse =
      zio.aws.nimble.model
        .GetLaunchProfileMemberResponse(member.map(value => value.asEditable))
    def member: Optional[zio.aws.nimble.model.LaunchProfileMembership.ReadOnly]
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.LaunchProfileMembership.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberResponse
  ) extends zio.aws.nimble.model.GetLaunchProfileMemberResponse.ReadOnly {
    override val member
        : Optional[zio.aws.nimble.model.LaunchProfileMembership.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.nimble.model.LaunchProfileMembership.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberResponse
  ): zio.aws.nimble.model.GetLaunchProfileMemberResponse.ReadOnly = new Wrapper(
    impl
  )
}
