package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLaunchProfileDetailsResponse(
    launchProfile: Optional[zio.aws.nimble.model.LaunchProfile] =
      Optional.Absent,
    streamingImages: Optional[Iterable[zio.aws.nimble.model.StreamingImage]] =
      Optional.Absent,
    studioComponentSummaries: Optional[
      Iterable[zio.aws.nimble.model.StudioComponentSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse = {
    import GetLaunchProfileDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse
      .builder()
      .optionallyWith(launchProfile.map(value => value.buildAwsValue()))(
        _.launchProfile
      )
      .optionallyWith(
        streamingImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamingImages)
      .optionallyWith(
        studioComponentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.studioComponentSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly =
    zio.aws.nimble.model.GetLaunchProfileDetailsResponse.wrap(buildAwsValue())
}
object GetLaunchProfileDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetLaunchProfileDetailsResponse =
      zio.aws.nimble.model.GetLaunchProfileDetailsResponse(
        launchProfile.map(value => value.asEditable),
        streamingImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        studioComponentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchProfile: Optional[zio.aws.nimble.model.LaunchProfile.ReadOnly]
    def streamingImages
        : Optional[List[zio.aws.nimble.model.StreamingImage.ReadOnly]]
    def studioComponentSummaries
        : Optional[List[zio.aws.nimble.model.StudioComponentSummary.ReadOnly]]
    def getLaunchProfile
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfile.ReadOnly] =
      AwsError.unwrapOptionField("launchProfile", launchProfile)
    def getStreamingImages: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StreamingImage.ReadOnly
    ]] = AwsError.unwrapOptionField("streamingImages", streamingImages)
    def getStudioComponentSummaries: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioComponentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "studioComponentSummaries",
      studioComponentSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse
  ) extends zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly {
    override val launchProfile
        : Optional[zio.aws.nimble.model.LaunchProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchProfile())
        .map(value => zio.aws.nimble.model.LaunchProfile.wrap(value))
    override val streamingImages
        : Optional[List[zio.aws.nimble.model.StreamingImage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingImages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StreamingImage.wrap(item)
          }.toList
        )
    override val studioComponentSummaries
        : Optional[List[zio.aws.nimble.model.StudioComponentSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioComponentSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StudioComponentSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse
  ): zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
