package zio.aws.nimble.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{EulaId, EulaAcceptanceId, Timestamp}
import scala.jdk.CollectionConverters._
final case class EulaAcceptance(
    acceptedAt: Optional[Timestamp] = Optional.Absent,
    acceptedBy: Optional[String] = Optional.Absent,
    accepteeId: Optional[String] = Optional.Absent,
    eulaAcceptanceId: Optional[EulaAcceptanceId] = Optional.Absent,
    eulaId: Optional[EulaId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.EulaAcceptance = {
    import EulaAcceptance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.EulaAcceptance
      .builder()
      .optionallyWith(
        acceptedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.acceptedAt)
      .optionallyWith(acceptedBy.map(value => value: java.lang.String))(
        _.acceptedBy
      )
      .optionallyWith(accepteeId.map(value => value: java.lang.String))(
        _.accepteeId
      )
      .optionallyWith(
        eulaAcceptanceId.map(value =>
          EulaAcceptanceId.unwrap(value): java.lang.String
        )
      )(_.eulaAcceptanceId)
      .optionallyWith(
        eulaId.map(value => EulaId.unwrap(value): java.lang.String)
      )(_.eulaId)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.EulaAcceptance.ReadOnly =
    zio.aws.nimble.model.EulaAcceptance.wrap(buildAwsValue())
}
object EulaAcceptance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.EulaAcceptance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.EulaAcceptance =
      zio.aws.nimble.model.EulaAcceptance(
        acceptedAt.map(value => value),
        acceptedBy.map(value => value),
        accepteeId.map(value => value),
        eulaAcceptanceId.map(value => value),
        eulaId.map(value => value)
      )
    def acceptedAt: Optional[Timestamp]
    def acceptedBy: Optional[String]
    def accepteeId: Optional[String]
    def eulaAcceptanceId: Optional[EulaAcceptanceId]
    def eulaId: Optional[EulaId]
    def getAcceptedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("acceptedAt", acceptedAt)
    def getAcceptedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("acceptedBy", acceptedBy)
    def getAccepteeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accepteeId", accepteeId)
    def getEulaAcceptanceId: ZIO[Any, AwsError, EulaAcceptanceId] =
      AwsError.unwrapOptionField("eulaAcceptanceId", eulaAcceptanceId)
    def getEulaId: ZIO[Any, AwsError, EulaId] =
      AwsError.unwrapOptionField("eulaId", eulaId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.EulaAcceptance
  ) extends zio.aws.nimble.model.EulaAcceptance.ReadOnly {
    override val acceptedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val acceptedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptedBy())
      .map(value => value: String)
    override val accepteeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accepteeId())
      .map(value => value: String)
    override val eulaAcceptanceId: Optional[EulaAcceptanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eulaAcceptanceId())
        .map(value => zio.aws.nimble.model.primitives.EulaAcceptanceId(value))
    override val eulaId: Optional[EulaId] = zio.aws.core.internal
      .optionalFromNullable(impl.eulaId())
      .map(value => zio.aws.nimble.model.primitives.EulaId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.EulaAcceptance
  ): zio.aws.nimble.model.EulaAcceptance.ReadOnly = new Wrapper(impl)
}
