package zio.aws.nimble.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.nimble.model.primitives.{EulaName, EulaId, Timestamp}
import scala.jdk.CollectionConverters._
final case class Eula(
    content: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    eulaId: Optional[EulaId] = Optional.Absent,
    name: Optional[EulaName] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.nimble.model.Eula = {
    import Eula.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.Eula
      .builder()
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        eulaId.map(value => EulaId.unwrap(value): java.lang.String)
      )(_.eulaId)
      .optionallyWith(
        name.map(value => EulaName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.Eula.ReadOnly =
    zio.aws.nimble.model.Eula.wrap(buildAwsValue())
}
object Eula {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.nimble.model.Eula] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.Eula = zio.aws.nimble.model.Eula(
      content.map(value => value),
      createdAt.map(value => value),
      eulaId.map(value => value),
      name.map(value => value),
      updatedAt.map(value => value)
    )
    def content: Optional[String]
    def createdAt: Optional[Timestamp]
    def eulaId: Optional[EulaId]
    def name: Optional[EulaName]
    def updatedAt: Optional[Timestamp]
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEulaId: ZIO[Any, AwsError, EulaId] =
      AwsError.unwrapOptionField("eulaId", eulaId)
    def getName: ZIO[Any, AwsError, EulaName] =
      AwsError.unwrapOptionField("name", name)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.Eula
  ) extends zio.aws.nimble.model.Eula.ReadOnly {
    override val content: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val eulaId: Optional[EulaId] = zio.aws.core.internal
      .optionalFromNullable(impl.eulaId())
      .map(value => zio.aws.nimble.model.primitives.EulaId(value))
    override val name: Optional[EulaName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.nimble.model.primitives.EulaName(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.Eula
  ): zio.aws.nimble.model.Eula.ReadOnly = new Wrapper(impl)
}
