package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLaunchProfileResponse(
    launchProfile: Optional[zio.aws.nimble.model.LaunchProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateLaunchProfileResponse = {
    import CreateLaunchProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateLaunchProfileResponse
      .builder()
      .optionallyWith(launchProfile.map(value => value.buildAwsValue()))(
        _.launchProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateLaunchProfileResponse.ReadOnly =
    zio.aws.nimble.model.CreateLaunchProfileResponse.wrap(buildAwsValue())
}
object CreateLaunchProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateLaunchProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateLaunchProfileResponse =
      zio.aws.nimble.model.CreateLaunchProfileResponse(
        launchProfile.map(value => value.asEditable)
      )
    def launchProfile: Optional[zio.aws.nimble.model.LaunchProfile.ReadOnly]
    def getLaunchProfile
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfile.ReadOnly] =
      AwsError.unwrapOptionField("launchProfile", launchProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateLaunchProfileResponse
  ) extends zio.aws.nimble.model.CreateLaunchProfileResponse.ReadOnly {
    override val launchProfile
        : Optional[zio.aws.nimble.model.LaunchProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchProfile())
        .map(value => zio.aws.nimble.model.LaunchProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateLaunchProfileResponse
  ): zio.aws.nimble.model.CreateLaunchProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
