package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioComponentName,
  SecurityGroupId,
  StudioComponentDescription,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStudioComponentRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    configuration: Optional[zio.aws.nimble.model.StudioComponentConfiguration] =
      Optional.Absent,
    description: Optional[StudioComponentDescription] = Optional.Absent,
    ec2SecurityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    initializationScripts: Optional[
      Iterable[zio.aws.nimble.model.StudioComponentInitializationScript]
    ] = Optional.Absent,
    name: Optional[StudioComponentName] = Optional.Absent,
    scriptParameters: Optional[
      Iterable[zio.aws.nimble.model.ScriptParameterKeyValue]
    ] = Optional.Absent,
    studioComponentId: String,
    studioId: String,
    subtype: Optional[zio.aws.nimble.model.StudioComponentSubtype] =
      Optional.Absent,
    `type`: Optional[zio.aws.nimble.model.StudioComponentType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateStudioComponentRequest = {
    import UpdateStudioComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateStudioComponentRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value =>
          StudioComponentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ec2SecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SecurityGroupIds)
      .optionallyWith(
        initializationScripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.initializationScripts)
      .optionallyWith(
        name.map(value => StudioComponentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        scriptParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scriptParameters)
      .studioComponentId(studioComponentId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .optionallyWith(subtype.map(value => value.unwrap))(_.subtype)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateStudioComponentRequest.ReadOnly =
    zio.aws.nimble.model.UpdateStudioComponentRequest.wrap(buildAwsValue())
}
object UpdateStudioComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateStudioComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateStudioComponentRequest =
      zio.aws.nimble.model.UpdateStudioComponentRequest(
        clientToken.map(value => value),
        configuration.map(value => value.asEditable),
        description.map(value => value),
        ec2SecurityGroupIds.map(value => value),
        initializationScripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        scriptParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        studioComponentId,
        studioId,
        subtype.map(value => value),
        `type`.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def configuration
        : Optional[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly]
    def description: Optional[StudioComponentDescription]
    def ec2SecurityGroupIds: Optional[List[SecurityGroupId]]
    def initializationScripts: Optional[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ]
    def name: Optional[StudioComponentName]
    def scriptParameters
        : Optional[List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]]
    def studioComponentId: String
    def studioId: String
    def subtype: Optional[zio.aws.nimble.model.StudioComponentSubtype]
    def `type`: Optional[zio.aws.nimble.model.StudioComponentType]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, StudioComponentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("ec2SecurityGroupIds", ec2SecurityGroupIds)
    def getInitializationScripts: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly
    ]] =
      AwsError.unwrapOptionField("initializationScripts", initializationScripts)
    def getName: ZIO[Any, AwsError, StudioComponentName] =
      AwsError.unwrapOptionField("name", name)
    def getScriptParameters: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly
    ]] = AwsError.unwrapOptionField("scriptParameters", scriptParameters)
    def getStudioComponentId: ZIO[Any, Nothing, String] =
      ZIO.succeed(studioComponentId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getSubtype
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentSubtype] =
      AwsError.unwrapOptionField("subtype", subtype)
    def getType: ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioComponentRequest
  ) extends zio.aws.nimble.model.UpdateStudioComponentRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val configuration
        : Optional[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          zio.aws.nimble.model.StudioComponentConfiguration.wrap(value)
        )
    override val description: Optional[StudioComponentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.nimble.model.primitives.StudioComponentDescription(value)
        )
    override val ec2SecurityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val initializationScripts: Optional[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.initializationScripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StudioComponentInitializationScript.wrap(item)
        }.toList
      )
    override val name: Optional[StudioComponentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.nimble.model.primitives.StudioComponentName(value))
    override val scriptParameters: Optional[
      List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.ScriptParameterKeyValue.wrap(item)
        }.toList
      )
    override val studioComponentId: String = impl.studioComponentId(): String
    override val studioId: String = impl.studioId(): String
    override val subtype
        : Optional[zio.aws.nimble.model.StudioComponentSubtype] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subtype())
        .map(value => zio.aws.nimble.model.StudioComponentSubtype.wrap(value))
    override val `type`: Optional[zio.aws.nimble.model.StudioComponentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.nimble.model.StudioComponentType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioComponentRequest
  ): zio.aws.nimble.model.UpdateStudioComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
