package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StreamingSessionStorageRootPathWindows,
  StreamingSessionStorageRootPathLinux
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamingSessionStorageRoot(
    linux: Optional[StreamingSessionStorageRootPathLinux] = Optional.Absent,
    windows: Optional[StreamingSessionStorageRootPathWindows] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamingSessionStorageRoot = {
    import StreamingSessionStorageRoot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamingSessionStorageRoot
      .builder()
      .optionallyWith(
        linux.map(value =>
          StreamingSessionStorageRootPathLinux.unwrap(value): java.lang.String
        )
      )(_.linux)
      .optionallyWith(
        windows.map(value =>
          StreamingSessionStorageRootPathWindows.unwrap(value): java.lang.String
        )
      )(_.windows)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamingSessionStorageRoot.ReadOnly =
    zio.aws.nimble.model.StreamingSessionStorageRoot.wrap(buildAwsValue())
}
object StreamingSessionStorageRoot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamingSessionStorageRoot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamingSessionStorageRoot =
      zio.aws.nimble.model.StreamingSessionStorageRoot(
        linux.map(value => value),
        windows.map(value => value)
      )
    def linux: Optional[StreamingSessionStorageRootPathLinux]
    def windows: Optional[StreamingSessionStorageRootPathWindows]
    def getLinux: ZIO[Any, AwsError, StreamingSessionStorageRootPathLinux] =
      AwsError.unwrapOptionField("linux", linux)
    def getWindows: ZIO[Any, AwsError, StreamingSessionStorageRootPathWindows] =
      AwsError.unwrapOptionField("windows", windows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSessionStorageRoot
  ) extends zio.aws.nimble.model.StreamingSessionStorageRoot.ReadOnly {
    override val linux: Optional[StreamingSessionStorageRootPathLinux] =
      zio.aws.core.internal
        .optionalFromNullable(impl.linux())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StreamingSessionStorageRootPathLinux(value)
        )
    override val windows: Optional[StreamingSessionStorageRootPathWindows] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windows())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StreamingSessionStorageRootPathWindows(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSessionStorageRoot
  ): zio.aws.nimble.model.StreamingSessionStorageRoot.ReadOnly = new Wrapper(
    impl
  )
}
